% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot_cofeature_mat.R
\name{plot_cofeature_mat}
\alias{plot_cofeature_mat}
\title{Plot a Cofeature Matrix}
\usage{
plot_cofeature_mat(in.df, feature.order, sample.id.order, fill.colors,
  type.display.mode = c("multiple", "single"), type.order, tile.col = NA,
  rotate.x.labels, missing.fill.col)
}
\arguments{
\item{in.df}{A 3 column (feature, sampleID, type) data.frame object}

\item{feature.order}{character vector indicating the order of the features
in the final plot on the y-axis. If not set, then function will set it
automatically}

\item{sample.id.order}{character vector indicating the order of the samples
in the final plot on the x-axis. If not set, then function will set it
automatically}

\item{fill.colors}{character vector indicating the colors of the different
"types". The names should be the types with the value being the color}

\item{type.display.mode}{Specify whether multiple or a single feature type
can appear in the same feature/sample cell}

\item{type.order}{Specify the "priority" of the feature types. This only
has an effect when type.display.mode is set to single}

\item{tile.col}{Border color of each cell. If not yet, no border color is
used}

\item{rotate.x.labels}{Rotate the x-axes labels by a certain degree}

\item{missing.fill.col}{Color of the cell that has missing values}
}
\description{
Generates a ggplot2::geom_tile plot of features by sample.
It is able to deal with multiple types affecting the same sample.
}
\examples{
v1 <- c("RCOR1", "NCOR1", "LCOR", "RCOR1", "RCOR1", "RCOR1", "RCOR1")
v2 <- c("sampleA", "sampleC", "sampleB", "sampleC", "sampleA", "sampleC", "sampleC")
v3 <- c("Deletion", "Deletion", "SNV", "Rearrangement", "SNV", "Rearrangement", "SNV")
feature.order <- c("RCOR1", "NCOR1", "LCOR")
sample.id.order <- c("sampleA", "sampleB", "sampleC")
in.df <- dplyr::data_frame(feature = v1, sampleID = v2, type = v3)
fill.colors <- c("Deletion" = "Blue", "Rearrangement" = "Green", "SNV" = "Red")

plot_cofeature_mat(in.df)

# With black tile color
plot_cofeature_mat(in.df, tile.col = "black")

# Fill in missing values with a lightgrey color
plot_cofeature_mat(in.df, tile.col = "black",
  missing.fill.col = "lightgrey")

# Rotate x-axes labels by 90 degrees
plot_cofeature_mat(in.df, rotate.x.labels = 90)

# Specify order of features, samples, and colors
plot_cofeature_mat(in.df, feature.order, sample.id.order,
   fill.colors = fill.colors)

# Specify each cell can only have one "feature type"
plot_cofeature_mat(in.df, feature.order, sample.id.order, fill.colors = fill.colors,
  type.display.mode = "single")

# Specify the specific priority of the "feature type" for cells with
# multiple features
plot_cofeature_mat(in.df, feature.order, sample.id.order, fill.colors = fill.colors,
  type.display.mode = "single", type.order = c("Rearrangement", "SNV", "Deletion"))
}

