% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-quotes.R
\name{QuotesSocCMap}
\alias{QuotesSocCMap}
\title{Extract all quotes of documents (or a Social Cognitive Map)}
\usage{
QuotesSocCMap(project, min.weight = 1, filters = NULL, units = "all")
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{min.weight}{A integer that will determine the minimum (>=) weight of relationships that will be taken into account. Relationships with a lower weight (<) will not be shown. Default is set to 1 (\emph{i.e.} all relationships are shown).}

\item{filters}{A list of named strings that will filter the relationships showed in the SCM. e.g. =list(coding_class = "A_coding_class", document_part = "A_document_part")=. To date, these filters are linked to the nature of relationships.}

\item{units}{A string vector giving the names of the units (i.e. classes linked to documents) that will be include in the SCM. It is a second type of filter.}
}
\value{
A data frame of relationships and quotes
}
\description{
Extract all quotes of a group of documents (or of an Social Cognitive Map)
}
\details{
This function creates a data frame with all quotes of a a group of documents of a Qualitative Data Analysis (QDA) project
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

QuotesSocCMap(my.project)
QuotesSocCMap(my.project, units = 'Québec')
}
