% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order.R
\name{f_rf_rsquared}
\alias{f_rf_rsquared}
\alias{f_rf_deviance}
\title{R-squared of Random Forest model}
\usage{
f_rf_rsquared(x, y, df)

f_rf_deviance(x, y, df)
}
\arguments{
\item{x}{(required, character string) name of the predictor variable.}

\item{y}{(required, character string) name of the response variable}

\item{df}{(required, data frame) data frame with the columns 'x' and 'y'.}
}
\value{
R-squared
}
\description{
Computes a univariate random forest model with \verb{\link[ranger]\{ranger\}} and returns the R-squared on the out-of-bag data.
}
\details{
\code{f_rf_rsquared()} and \code{f_rf_deviance()} are synonyms
}
\examples{

data(vi)

#subset to limit example run time
vi <- vi[1:1000, ]

#this example requires "ranger" installed in the system
if(requireNamespace(package = "ranger", quietly = TRUE)){

  f_rf_rsquared(
    x = "growing_season_length", #predictor
    y = "vi_mean",               #response
    df = vi
  )

}

}
