% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify.R
\name{identify_predictors_zero_variance}
\alias{identify_predictors_zero_variance}
\title{Identify Zero and Near-Zero Variance Predictors}
\usage{
identify_predictors_zero_variance(df = NULL, predictors = NULL, decimals = 4)
}
\arguments{
\item{df}{(required; data frame, tibble, or sf) A data frame with responses and predictors. Default: NULL.}

\item{predictors}{(optional; character vector) Names of the predictors to select from \code{df}. If omitted, all numeric columns in \code{df} are used instead. If argument \code{response} is not provided, non-numeric variables are ignored. Default: NULL}

\item{decimals}{(required, integer) Number of decimal places for the zero variance test. Smaller numbers will increase the number of variables detected as near-zero variance. Recommended values will depend on the range of the numeric variables in 'df'. Default: 4}
}
\value{
character vector: names of zero and near-zero variance columns.
}
\description{
Variables with a variance of zero or near-zero are highly problematic for multicollinearity analysis and modelling in general. This function identifies these variables with a level of sensitivity defined by the 'decimals' argument. Smaller number of decimals increase the number of variables detected as near zero variance. Recommended values will depend on the range of the numeric variables in 'df'.
}
\examples{

data(
  vi,
  vi_predictors
)

#create zero variance predictors
vi$zv_1 <- 1
vi$zv_2 <- runif(n = nrow(vi), min = 0, max = 0.0001)


#add to vi predictors
vi_predictors <- c(
  vi_predictors,
  "zv_1",
  "zv_2"
)

#identify zero variance predictors
zero.variance.predictors <- identify_predictors_zero_variance(
  df = vi,
  predictors = vi_predictors
)

zero.variance.predictors

}
\seealso{
Other data_types: 
\code{\link{identify_predictors}()},
\code{\link{identify_predictors_categorical}()},
\code{\link{identify_predictors_numeric}()},
\code{\link{identify_predictors_type}()},
\code{\link{identify_response_type}()}
}
\author{
Blas M. Benito, PhD
}
\concept{data_types}
