% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c4a.R
\name{c4a}
\alias{c4a}
\alias{c4a_na}
\title{Get a cols4all color palette}
\usage{
c4a(
  palette = NULL,
  n = NA,
  m = NA,
  type = c("cat", "seq", "div", "bivs", "bivc", "bivd", "bivg"),
  reverse = FALSE,
  order = NULL,
  range = NA,
  format = c("hex", "RGB", "HCL"),
  nm_invalid = c("error", "repeat", "interpolate"),
  verbose = TRUE
)

c4a_na(palette = NULL, type = c("cat", "seq", "div"), verbose = TRUE)
}
\arguments{
\item{palette}{name of the palette. See \code{\link{c4a_palettes}} for options. If omitted, the default palette is provided by \code{c4a_default_palette}. The palette name can be prefixed with a \code{"-"} symbol, which will reverse the palette (this can also be done with the \code{reverse} argument).}

\item{n}{number of colors. If omitted then: for type \code{"cat"} the maximum number of colors is returned, for types \code{"seq"} and \code{"div"}, 9 colors.}

\item{m}{number of rows in case type is \code{"bivs"}, \code{"bivc"}, \code{"bivd"} or  \code{"bivg"} (which stand for respectively sequential, categorical, diverging and desaturated (\code{g} for 'grayscale')).}

\item{type}{type of color palette, in case \code{palette} is not specified: one of \code{"cat"} (categorical/qualitative palette), \code{"seq"} (sequential palette), \code{"div"} (diverging palette), and \code{"bivs"}/\code{"bivc"}/\code{"bivd"}/\code{"bivg"} (bivariate: respectively seq-seq seq-cat, seq-div, and seq-desaturated).}

\item{reverse}{should the palette be reversed?}

\item{order}{order of colors. Only applicable for \code{"cat"} palettes}

\item{range}{a vector of two numbers between 0 and 1 that determine the range that is used for sequential and diverging palettes. The first number determines where the palette begins, and the second number where it ends. For sequential \code{"seq"} palettes, 0 means the leftmost (normally lightest) color, and 1 the rightmost (often darkest) color. For diverging \code{"seq"} palettes, 0 means the middle color, and 1 both extremes. If only one number is provided, this number is interpreted as the endpoint (with 0 taken as the start).}

\item{format}{format of the colors. One of: \code{"hex"} character vector of hex color values, \code{"RGB"} 3 column matrix of RGB values, or \code{"HCL"} 3-column matrix of HCL values}

\item{nm_invalid}{what should be done in case \code{n} or \code{m} is larger than the maximum number of colors or smaller than the minimum number? Options are \code{"error"} (an error is returned), \code{"repeat"}, the palette is repeated, \code{"interpolate"} colors are interpolated. For categorical \code{"cat"} palettes only.}

\item{verbose}{should messages be printed?}
}
\value{
A vector of colors (\code{c4a}) and a color (\code{c4a_na})
}
\description{
Get a cols4all color palette: \code{c4a} returns the colors of the specified palette, and \code{c4a_na} returns the color for missing value that is associated with the specified palette. Run \code{\link{c4a_gui}} to see all available palettes, which are also listed with \code{\link{c4a_palettes}}.
}
\examples{
c4a_palettes("div")

c4a(type = "cat")

(pal = c4a("tol.sunset", n = 7, range = c(0, .6)))

c4a_plot(pal)

c4a("set2")

c4a("hcl.set2")

c4a("hcl.set2", n = 8)

# reversed palette
c4a("hcl.set2", reverse = TRUE, n = 8)

# handy shortcut
c4a("-hcl.set2", n = 8)

# the color for missing values is white:
c4a_na("hcl.set2")
}
