% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colt_theme.R
\name{colt_theme}
\alias{colt_theme}
\alias{set_theme}
\title{Create and set color themes}
\usage{
colt_theme(clt_default = crayon:::mypaste, clt_h1 = crayon:::mypaste,
  clt_h2 = crayon:::mypaste, clt_chr = crayon:::mypaste,
  clt_chr_accent = crayon:::mypaste, clt_chr_subtle = crayon:::mypaste,
  clt_true = crayon:::mypaste, clt_false = crayon:::mypaste,
  clt_maybe = crayon:::mypaste, clt_num = crayon:::mypaste,
  clt_num_accent = crayon:::mypaste, clt_num_subtle = crayon:::mypaste,
  clt_bg = crayon:::mypaste, clt_bg_subtle = crayon:::mypaste,
  clt_bg_accent = crayon:::mypaste, clt_na = crayon:::mypaste,
  clt_nan = crayon:::mypaste, clt_inf = crayon:::mypaste,
  clt_null = crayon:::mypaste, clt_info = crayon:::mypaste,
  clt_message = crayon:::mypaste, clt_warning = crayon:::mypaste,
  clt_error = crayon:::mypaste, clt_emph = crayon:::mypaste,
  clt_emph2 = crayon:::mypaste)

set_theme(x)
}
\arguments{
\item{clt_default}{Default text style}

\item{clt_h1}{Header Level 1}

\item{clt_h2}{Header Level 2}

\item{clt_chr}{Text}

\item{clt_chr_accent}{Text (accented)}

\item{clt_chr_subtle}{Text (subtle)}

\item{clt_true}{TRUE}

\item{clt_false}{FALSE}

\item{clt_maybe}{Undecided}

\item{clt_num}{Numeric values}

\item{clt_num_accent}{Numeric values (accented)}

\item{clt_num_subtle}{Numeric values (subtle)}

\item{clt_bg}{Text background}

\item{clt_bg_subtle}{Text background (subtle)}

\item{clt_bg_accent}{Text background (accented)}

\item{clt_na}{NA values}

\item{clt_nan}{NAN values}

\item{clt_inf}{INF values}

\item{clt_null}{NULL values}

\item{clt_info}{INFO level messages}

\item{clt_message}{MESSAGE level messages}

\item{clt_warning}{Warnings}

\item{clt_error}{Errors}

\item{clt_emph}{Emphasis}

\item{clt_emph2}{stronger Emphasis}

\item{x}{A \code{colt_theme} Object. If \code{x} is missing, colors will be switched
off}
}
\value{
\code{colt_theme()} creates a new colt_theme Object.

\code{set_theme()} returns the input theme Objects invisibly.
}
\description{
Colt comes with two default color themes: \code{clt_theme_light} and
\code{clt_theme_dark}. A \code{colt_theme} is just a list of functions, so it is
easy to create your own theme. Use \code{set_colt_theme()} to switch between
themes.
}
\examples{
mytheme <- colt_theme(
  clt_h1 = crayon::combine_styles(crayon::red, crayon::bold)
)

mytheme  # preview theme

cat(clt_h1("Important"))

set_theme(mytheme)
cat(clt_h1("Important"))

set_theme(clt_theme_light)
cat(clt_h1("Important"))

}
