% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{scores}
\alias{scores}
\title{Calculate scores for track and field combined events}
\usage{
scores(marks, gender, combined_event = NULL, seconds = FALSE)
}
\arguments{
\item{marks}{a numeric or character vector of track and field
marks/performances}

\item{gender}{gender of athlete; either "\code{male}" or "\code{female}"}

\item{combined_event}{an optional character string indicating the
combined events competition. For \code{gender = "male"}, the options are
"\code{decathlon}"/"\code{outdoor decathlon}", "\code{outdoor pentathlon}",
"\code{heptathlon}"/"\code{indoor heptathlon}", and "\code{indoor pentathlon}".
For \code{gender = "female"}, the options are "\code{heptathlon}"/"\code{outdoor heptathlon}",
"\code{decathlon}"/"\code{outdoor decathlon}", and "\code{pentathlon}"/"\code{indoor pentathlon}".
If \code{combined_event = NULL}, the elements of \code{marks} must be named.
\itemize{
\item For \code{gender = "male"}, the allowed names for the elements
of \code{marks} are \code{`100m`}, \code{LJ}, \code{SP}, \code{HJ}, \code{`400m`}, \code{`110mH`}, \code{DT}, \code{PV}, \code{JT}, \code{`1500m`},
\code{`200m`}, \code{`60m`}, \code{`60mH`}, and \code{`1000m`}.
\item For \code{gender = "female"}, the allowed names are \code{`100m`}, \code{LJ},
\code{SP}, \code{HJ}, \code{`400m`}, \code{`100mH`}, \code{DT}, \code{PV}, \code{JT}, \code{`1500m`}, \code{`200m`}, \code{`60mH`}, and \code{`800m`}.
}}

\item{seconds}{a logical; if \code{TRUE}, will return all track event marks in seconds}
}
\value{
A list of class "\code{combined_events}" (or "\code{combined_events_null}" if \code{combined_event = NULL}) with
the following fields:
\item{results}{if called with non-NULL \code{combined_event}, a data frame with
columns for the specified combined event containing the names of those events, \code{mark}
for the input marks/performances, and \code{score} for the resulting scores based on those
marks. The last row of the data frame gives the total score for the specified combined
events competition. If \code{combined_event = NULL}, a data frame with columns \code{event},
\code{mark}, and \code{score}.}
\item{marks}{the vector of marks for the specified combined event. If not all marks were
supplied to \code{scores()}, then there will be \code{NA} values for those events with
missing marks. If \code{combined_event = NULL}, the vector of marks.}
\item{scores}{the vector of scores based on the input marks for the specified combined event.
If not all marks were supplied to \code{scores()}, then there will be scores with \code{NA}
values for those events with missing marks. If \code{combined_event = NULL}, the vector of scores.}
\item{score_total}{if called with non-NULL \code{combined_event}, an integer representing the overall score
for the specified combined events competition}
\item{call}{the matched call}
}
\description{
\code{scores()} calculates scores for track and field combined events competitions.
}
\examples{
# Men's decathlon
scores(marks = c(`100m` = 11.61, LJ = 7.32, SP = 13.17, HJ = 1.9,
                 `400m` = 49.96, `110mH` = 15.32, DT = 38.18, PV = 4.6,
                 JT = 58.98, `1500m` = "4:39.34"),
       gender = "male", combined_event = "decathlon")

# Women's heptathlon
scores(c(14.11, 1.95, 13.96, 25.61, 6.44, 45.98, "2:07.26"),
       "female", "heptathlon")

# Men's events
scores(c(`60m` = 7.09, LJ = 7, LJ = 7.03, SP = 11.8, HJ = 2,
         `60mH` = 8.30, `60mH` = 9.31, PV = 4.30, `1000m` = "2:40.00"),
       gender = "male")
}
\references{
International Association of Athletics Federation (2001).
\emph{IAAF Scoring Tables for Combined Events}.
}
