% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logged-artifact.R
\name{LoggedArtifact}
\alias{LoggedArtifact}
\title{A Logged Comet Artifact object}
\description{
Comet Artifacts allow keeping track of assets beyond any particular experiment.
The \code{LoggedArtifact} is a Comet \code{\link{Artifact}} that already logged to the Comet servers
and can be used to access the artifact version assets and download them locally.
}
\examples{
\dontrun{
library(cometr)
# Assuming you have COMET_API_KEY, COMET_WORKSPACE, COMET_PROJECT_NAME variables define
exp <- create_experiment()

# Get a Comet Artifact
artifact <- exp$get_artifact(artifact_name = "workspace/artifact-name:versionOrAlias")

exp$stop()
}

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LoggedArtifact-new}{\code{LoggedArtifact$new()}}
\item \href{#method-LoggedArtifact-get_artifact_name}{\code{LoggedArtifact$get_artifact_name()}}
\item \href{#method-LoggedArtifact-get_artifact_type}{\code{LoggedArtifact$get_artifact_type()}}
\item \href{#method-LoggedArtifact-get_artifact_version}{\code{LoggedArtifact$get_artifact_version()}}
\item \href{#method-LoggedArtifact-get_artifact_id}{\code{LoggedArtifact$get_artifact_id()}}
\item \href{#method-LoggedArtifact-get_artifact_tags}{\code{LoggedArtifact$get_artifact_tags()}}
\item \href{#method-LoggedArtifact-get_aliases}{\code{LoggedArtifact$get_aliases()}}
\item \href{#method-LoggedArtifact-get_metadata}{\code{LoggedArtifact$get_metadata()}}
\item \href{#method-LoggedArtifact-get_version_tags}{\code{LoggedArtifact$get_version_tags()}}
\item \href{#method-LoggedArtifact-get_workspace}{\code{LoggedArtifact$get_workspace()}}
\item \href{#method-LoggedArtifact-get_artifact_version_id}{\code{LoggedArtifact$get_artifact_version_id()}}
\item \href{#method-LoggedArtifact-get_source_experiment_key}{\code{LoggedArtifact$get_source_experiment_key()}}
\item \href{#method-LoggedArtifact-get_experiment_key}{\code{LoggedArtifact$get_experiment_key()}}
\item \href{#method-LoggedArtifact-size}{\code{LoggedArtifact$size()}}
\item \href{#method-LoggedArtifact-get_assets}{\code{LoggedArtifact$get_assets()}}
\item \href{#method-LoggedArtifact-get_remote_assets}{\code{LoggedArtifact$get_remote_assets()}}
\item \href{#method-LoggedArtifact-update_artifact_tags}{\code{LoggedArtifact$update_artifact_tags()}}
\item \href{#method-LoggedArtifact-update_version_tags}{\code{LoggedArtifact$update_version_tags()}}
\item \href{#method-LoggedArtifact-update_aliases}{\code{LoggedArtifact$update_aliases()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-new"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-new}{}}}
\subsection{Method \code{new()}}{
Creates new \code{LoggedArtifact} object with provided parameters. Do not use
this method directly. Use \code{Experiment$get_artifact()}
to retrieve \code{LoggedArtifact}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$new(
  artifact_name,
  artifact_type,
  artifact_id,
  artifact_version_id,
  workspace,
  experiment_key,
  artifact_version,
  aliases,
  artifact_tags,
  version_tags,
  size,
  metadata = NULL,
  source_experiment_key = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{artifact_name}}{(Required) Artifact name.}

\item{\code{artifact_type}}{(Required) The artifact type.}

\item{\code{artifact_id}}{(Required) The ID of artifact.}

\item{\code{artifact_version_id}}{(Required) The ID of Artifact Version.}

\item{\code{workspace}}{(Required) The workspace where artifact saved.}

\item{\code{experiment_key}}{(Required) The ID of the associated experiment.}

\item{\code{artifact_version}}{(Required) The latest artifact version.}

\item{\code{aliases}}{(Required) List of Artifact Version aliases.}

\item{\code{artifact_tags}}{(Required) The list of artifact tags.}

\item{\code{version_tags}}{(Required) List of Artifact Version tags.}

\item{\code{size}}{(Required) The total size of logged artifact version.
It is the sum of all the artifact version assets.}

\item{\code{metadata}}{The meta-data of Artifact Version.}

\item{\code{source_experiment_key}}{The ID of the experiment that created this artifact version.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_artifact_name"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_artifact_name}{}}}
\subsection{Method \code{get_artifact_name()}}{
Get the name of the artifact.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_artifact_name()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_artifact_type"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_artifact_type}{}}}
\subsection{Method \code{get_artifact_type()}}{
Get the type of the artifact.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_artifact_type()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_artifact_version"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_artifact_version}{}}}
\subsection{Method \code{get_artifact_version()}}{
Get the version of the artifact.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_artifact_version()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_artifact_id"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_artifact_id}{}}}
\subsection{Method \code{get_artifact_id()}}{
Get the ID of the artifact.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_artifact_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_artifact_tags"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_artifact_tags}{}}}
\subsection{Method \code{get_artifact_tags()}}{
Get the tags of the artifact.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_artifact_tags()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_aliases"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_aliases}{}}}
\subsection{Method \code{get_aliases()}}{
Get the version of the artifact.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_aliases()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_metadata"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_metadata}{}}}
\subsection{Method \code{get_metadata()}}{
Get the metadata of the artifact.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_metadata()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_version_tags"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_version_tags}{}}}
\subsection{Method \code{get_version_tags()}}{
Get the list of tags of the artifact version.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_version_tags()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_workspace"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_workspace}{}}}
\subsection{Method \code{get_workspace()}}{
Get the workspace of the Artifact.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_workspace()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_artifact_version_id"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_artifact_version_id}{}}}
\subsection{Method \code{get_artifact_version_id()}}{
The ID of current Artifact Version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_artifact_version_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_source_experiment_key"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_source_experiment_key}{}}}
\subsection{Method \code{get_source_experiment_key()}}{
The ID of the experiment that created this artifact version.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_source_experiment_key()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_experiment_key"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_experiment_key}{}}}
\subsection{Method \code{get_experiment_key()}}{
The ID of the associated experiment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_experiment_key()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-size"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-size}{}}}
\subsection{Method \code{size()}}{
Get/set artifact size.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$size(size = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{size}}{The new size for the Artifact or \code{NULL} if retrieving existing
size of the Artifact.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_assets"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_assets}{}}}
\subsection{Method \code{get_assets()}}{
Get the list of all \code{\link{LoggedArtifactAsset}} that have been logged with
this \code{LoggedArtifact} from Comet server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_assets()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-get_remote_assets"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-get_remote_assets}{}}}
\subsection{Method \code{get_remote_assets()}}{
Get the list of remote \code{\link{LoggedArtifactAsset}} that have been logged
with this \code{LoggedArtifact} from Comet server.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$get_remote_assets()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-update_artifact_tags"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-update_artifact_tags}{}}}
\subsection{Method \code{update_artifact_tags()}}{
Update the logged artifact tags
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$update_artifact_tags(artifact_tags)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{artifact_tags}}{The new tags for the artifact}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-update_version_tags"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-update_version_tags}{}}}
\subsection{Method \code{update_version_tags()}}{
Update the logged artifact version tags
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$update_version_tags(version_tags)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version_tags}}{The new tags for the artifact version}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifact-update_aliases"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifact-update_aliases}{}}}
\subsection{Method \code{update_aliases()}}{
Update the logged artifact version aliases
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifact$update_aliases(aliases)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{aliases}}{The new aliases for the artifact version}
}
\if{html}{\out{</div>}}
}
}
}
