% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecometric_space_qual.R
\name{ecometric_space_qual}
\alias{ecometric_space_qual}
\title{Plot ecometric space for qualitative environmental variables}
\usage{
ecometric_space_qual(
  model_out,
  palette = NULL,
  fossil_data = NULL,
  fossil_color = "#000000",
  modern_color = "#bc4749",
  x_label = "Summary metric 1",
  y_label = "Summary metric 2"
)
}
\arguments{
\item{model_out}{Output from \code{ecometric_model_qual()}, containing environmental estimates in trait space.}

\item{palette}{Optional color vector for categories (must match number of categories).}

\item{fossil_data}{Optional. Output from \code{reconstruct_env_qual()}.}

\item{fossil_color}{Outline color for fossil data bins (default = "#000000").}

\item{modern_color}{Outline color for modern data bins (default: \code{"#bc4749"}).}

\item{x_label}{Label for the x-axis in the output plots (default: "Summary metric 1").}

\item{y_label}{Label for the y-axis in the output plots (default: "Summary metric 2").}
}
\value{
A list containing:
\item{ecometric_space_plot}{ggplot showing the predicted category across trait space.}
\item{probability_maps}{List of ggplots showing probability surfaces across trait space for each category.}
}
\description{
Visualizes the predicted ecometric space (predicted category) and probability maps
for each category based on the output from \code{ecometric_model_qualitative()}.
}
\examples{
\donttest{
# Load internal data
data("geoPoints", package = "commecometrics")
data("traits", package = "commecometrics")
data("spRanges", package = "commecometrics")
data("fossils", package = "commecometrics")

# Summarize trait values at sampling points
traitsByPoint <- summarize_traits_by_point(
  points_df = geoPoints,
  trait_df = traits,
  species_polygons = spRanges,
  trait_column = "RBL",
  species_name_col = "sci_name",
  continent = FALSE,
  parallel = FALSE
)

# Run ecometric model for qualitative variable
modelResult <- ecometric_model_qual(
  points_df = traitsByPoint$points,
  category_col = "vegetation",
  min_species = 3
)

# Reconstruct fossil environmental categories
reconQual <- reconstruct_env_qual(
  fossildata = fossils,
  model_out = modelResult,
  match_nearest = TRUE,
  fossil_lon = "Long",
  fossil_lat = "Lat",
  modern_id = "ID",
  modern_lon = "Longitude",
  modern_lat = "Latitude"
)

# Plot qualitative ecometric space
ecoPlotQual <- ecometric_space_qual(
  model_out = modelResult,
  fossil_data = reconQual
)

# Display predicted category map
print(ecoPlotQual$ecometric_space_plot)

# Display one of the probability maps
print(ecoPlotQual$probability_maps[["1"]])
}
}
