% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Chebyshev.R
\name{Chebyshev}
\alias{Chebyshev}
\title{Chebyshev Numeric Comparator}
\usage{
Chebyshev()
}
\value{
A \code{Chebyshev} instance is returned, which is an S4 class inheriting
from \code{\linkS4class{NumericComparator}}.
}
\description{
The Chebyshev distance (a.k.a. L-Inf distance or ) between two vectors
\eqn{x} and \eqn{y} is the greatest of the absolute differences between each
coordinate:
\deqn{\mathrm{Chebyshev}(x,y) = \max_i |x_i - y_i|.}{Chebyshev(x, y) = max_i |x_i - y_i|.}
}
\note{
The Chebyshev distance is a limiting case of the \code{\link{Minkowski}}
distance where \eqn{p \to \infty}{p -> Inf}.
}
\examples{
## Distance between two vectors
x <- c(0, 1, 0, 1, 0)
y <- seq_len(5)
Chebyshev()(x, y)

## Distance between rows (elementwise) of two matrices
comparator <- Chebyshev()
x <- matrix(rnorm(25), nrow = 5)
y <- matrix(rnorm(5), nrow = 1)
elementwise(comparator, x, y)

## Distance between rows (pairwise) of two matrices
pairwise(comparator, x, y)

}
\seealso{
Other numeric comparators include \code{\link{Manhattan}}, \code{\link{Euclidean}} and
\code{\link{Minkowski}}.
}
