% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnsComparison.R
\name{compare_df}
\alias{compare_df}
\title{Compare Two dataframes}
\usage{
compare_df(df_new, df_old, group_col, exclude = NULL, limit_html = 100,
  tolerance = 0, tolerance_type = "ratio", stop_on_error = TRUE,
  keep_unchanged = FALSE, color_scheme = c(addition = "green", removal
  = "red", unchanged_cell = "gray", unchanged_row = "deepskyblue"),
  html_headers = NULL, html_change_col_name = "chng_type",
  html_group_col_name = "grp")
}
\arguments{
\item{df_new}{The data frame for which any changes will be shown as an addition (green)}

\item{df_old}{The data frame for which any changes will be shown as a removal (red)}

\item{group_col}{A character vector of a string of character vector showing the columns
by which to group_by.}

\item{exclude}{The columns which should be excluded from the comparison}

\item{limit_html}{maximum number of rows to show in the html diff. >1000 not recommended}

\item{tolerance}{The amount in fraction to which changes are ignored while showing the
visual representation. By default, the value is 0 and any change in the value of variables
is shown off. Doesn't apply to categorical variables.}

\item{tolerance_type}{Defaults to 'ratio'. The type of comparison for numeric values, can be 'ratio' or 'difference'}

\item{stop_on_error}{Whether to stop on acceptable errors on not}

\item{keep_unchanged}{whether to preserve unchanged values or not. Defaults to \code{FALSE}}

\item{color_scheme}{What color scheme to use for the HTML output. Should be a vector/list with
named_elements. Default - \code{c("addition" = "green", "removal" = "red", "unchanged_cell" = "gray", "unchanged_row" = "deepskyblue")}}

\item{html_headers}{A character vector of column names to be used in the table. Defaults to \code{colnames}.}

\item{html_change_col_name}{Name of the change column to use in the HTML table. Defaults to \code{chng_type}.}

\item{html_group_col_name}{Name of the group column to be used in the table (if there are multiple grouping vars). Defaults to \code{grp}.}
}
\description{
Do a git style comparison between two data frames of similar columnar structure
}
\examples{
old_df = data.frame(var1 = c("A", "B", "C"),
                    val1 = c(1, 2, 3))
new_df = data.frame(var1 = c("A", "B", "C"),
                    val1 = c(1, 2, 4))
ctable = compare_df(new_df, old_df, c("var1"))
print(ctable$comparison_df)
ctable$html_output
}
