% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medians.R
\name{mad}
\alias{mad}
\title{Median Absolute Deviation, compatible with complex variables}
\usage{
mad(
  x,
  center = median(x),
  constant = 1.4826,
  na.rm = FALSE,
  low = FALSE,
  high = FALSE
)
}
\arguments{
\item{x}{a numeric or complex vector.}

\item{center}{optional, numeric or complex. The center about which to calculate MAD. Defaults to median for numeric, and geo_median for complex.}

\item{constant}{a constant by which to multiply the median absolute deviation from center. Default is 1.4826, which is one over the quantile of 3/4 for the normal distribution.}

\item{na.rm}{logical. Should NAs be removed from x before calculating.}

\item{low}{logical. If TRUE, compute the "lo-median", i.e., for even sample size, do not average the two middle values, but take the smaller one. Not used if x is complex.}

\item{high}{logical. If TRUE, compute the "hi-median", i.e., take the larger of the two middle values for even sample size. Not used if x is complex.}
}
\value{
numeric. The median absolute deviation (MAD) from center.
}
\description{
Median absolute deviation, adapted to operate on complex data as well as numeric.
In the later case it simply calls \code{\link[stats:mad]{stats::mad()}}.
For complex x it uses the geometric median, \code{\link[pracma:geo_median]{pracma::geo_median()}}, as the center,
then returns the median absolute difference between center and each element of x, multiplied by \code{constant}.
}
\note{
The concept of quantile requires ordering to be defined, which the complex numbers lack.
The usefulness of multiplying by \code{constant} is thus called into question. However, for no more rigorous
reason than consistency, the default behavior of this function is to do so.
}
\examples{
set.seed(4242)
n <- 8
foo <- complex(real = rnorm(n), imaginary = rnorm(n))
mad(foo)
}
\seealso{
\link{median}, \link[stats:mad]{stats::mad}
}
