% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlm.wfit.R
\name{zhatvalues}
\alias{zhatvalues}
\title{Generate the Hat Matrix or Leverage Scores of a Complex Linear Model}
\usage{
zhatvalues(model, full = FALSE, ...)
}
\arguments{
\item{model}{A complex linear fit object, of class "zlm" or "rzlm". An object with numeric residuals will produce a warning and NULL output.}

\item{full}{Logical. If TRUE, return the entire hat matrix. If FALSE, return a vector of the diagonal elements of the hat matrix. These are the influence scores. Default is FALSE.}

\item{...}{Additional arguments. Not used.}
}
\value{
Either a \eqn{(n x n)} complex matrix or a length \eqn{n} numeric vector.
}
\description{
This function returns either the full hat matrix (AKA the projection matrix) of a complex "lm" or "rlm" object, or the diagonal elements of same.
The later are also known as the influence scores.
It performs the same basic role as \link[stats:influence.measures]{stats::hat} and \link[stats:influence.measures]{stats::hatvalues} do for numeric fits, but is quite a bit simpler
and rather less versatile.
\loadmathjax
}
\details{
For unweighted least-squares fits the hat matrix is calculated from the model matrix, \eqn{X = }\code{model$x}, as \cr
\mjdeqn{H = X (X^t X)^{-1} X^t}{H = X (X^t X)^{-1} X^t}\cr
For rlm or weighted least-squares fits the hat matrix is calculated as\cr
\mjdeqn{H = X (X^t W X)^{-1} X^t W}{H = X (X^t W X)^{-1} X^t W}
Where \eqn{^t} represents conjugate transpose, and \eqn{W} is the identity matrix times the user provided weights and the final IWLS weights if present. \cr
Note that this function requires that the model matrix be returned when calling \link{lm} or \link{rlm}.\cr
The diagonals will be purely real, and are converted to numeric if \code{full == FALSE}.
}
\examples{
set.seed(4242)
n <- 8
slop <- complex(real = 4.23, imaginary = 2.323)
interc <- complex(real = 1.4, imaginary = 1.804)
e <- complex(real=rnorm(n)/6, imaginary=rnorm(n)/6)
xx <- complex(real= rnorm(n), imaginary= rnorm(n))
tframe <- data.frame(x = xx, y= slop*xx + interc + e)
fit <- lm(y ~ x, data = tframe, weights = rep(1,n))
zhatvalues(fit)
}
\seealso{
\link[stats:influence.measures]{stats::hatvalues}, \link[stats:influence.measures]{stats::hat}, \link{cooks.distance}
}
