% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nns.R
\name{get_nns}
\alias{get_nns}
\title{Given a corpus and a set of candidate neighbors, find the top N nearest
neighbors.}
\usage{
get_nns(
  x,
  N = 10,
  groups = NULL,
  candidates = character(0),
  pre_trained,
  transform = TRUE,
  transform_matrix,
  bootstrap = TRUE,
  num_bootstraps = 10,
  as_list = TRUE
)
}
\arguments{
\item{x}{a (quanteda) \code{tokens-class} object}

\item{N}{(numeric) number of nearest neighbors to return}

\item{groups}{(numeric, factor, character) a binary variable of the same length as \code{x}}

\item{candidates}{(character) vector of features to consider as candidates to be nearest neighbor
You may for example want to only consider features that meet a certian count threshold
or exclude stop words etc. To do so you can simply identify the set of features you
want to consider and supply these as a character vector in the \code{candidates} argument.}

\item{pre_trained}{(numeric) a F x D matrix corresponding to pretrained embeddings.
F = number of features and D = embedding dimensions.
rownames(pre_trained) = set of features for which there is a pre-trained embedding.}

\item{transform}{(logical) if TRUE (default) apply the 'a la carte' transformation,
if FALSE ouput untransformed averaged embeddings.}

\item{transform_matrix}{(numeric) a D x D 'a la carte' transformation matrix.
D = dimensions of pretrained embeddings.}

\item{bootstrap}{(logical) if TRUE, use bootstrapping -- sample from texts with replacement and
re-estimate cosine similarities for each sample. Required to get std. errors.
If \code{groups} defined, sampling is automatically stratified.}

\item{num_bootstraps}{(integer) number of bootstraps to use.}

\item{as_list}{(logical) if FALSE all results are combined into a single data.frame
If TRUE, a list of data.frames is returned with one data.frame per target.}
}
\value{
a \code{data.frame} or list of data.frames (one for each target)
with the following columns:
\describe{
\item{\code{target}}{ (character) rownames of \code{x},
the labels of the ALC embeddings.}
\item{\code{feature}}{(character) features identified as nearest neighbors.}
\item{\code{rank}}{(character) rank of feature in terms of similarity with \code{x}.}
\item{\code{value}}{(numeric) cosine similarity between \code{x}
and feature. Average over bootstrapped samples if bootstrap = TRUE.}
\item{\code{std.error}}{(numeric) std. error of the similarity value.
Column is dropped if bootstrap = FALSE.}
}
}
\description{
This is a wrapper function for \code{nns()} that allows users to go from a
tokenized corpus to results with the option to bootstrap cosine similarities
and get the corresponding std. errors.
}
\examples{

library(quanteda)

# tokenize corpus
toks <- tokens(cr_sample_corpus)

# build a tokenized corpus of contexts sorrounding a target term
immig_toks <- tokens_context(x = toks, pattern = "immigr*", window = 6L)

# we limit candidates to features in our corpus
feats <- featnames(dfm(immig_toks))

# compare nearest neighbors between groups
set.seed(2021L)
immig_party_nns <- get_nns(x = immig_toks, N = 10,
                           groups = docvars(immig_toks, 'party'),
                           candidates = feats,
                           pre_trained = cr_glove_subset,
                           transform = TRUE,
                           transform_matrix = cr_transform,
                           bootstrap = TRUE,
                           num_bootstraps = 10,
                           as_list = TRUE)

# nearest neighbors of "immigration" for Republican party
immig_party_nns[["R"]]
}
\keyword{get_nns}
