% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_mean.R
\name{curve_mean}
\alias{curve_mean}
\title{Mean Interval Consonance Function}
\usage{
curve_mean(
  x,
  y,
  data,
  paired = F,
  method = "default",
  replicates = 1000,
  steps = 10000,
  table = TRUE
)
}
\arguments{
\item{x}{Variable that contains the data for the first group being compared.}

\item{y}{Variable that contains the data for the second group being compared.}

\item{data}{Data frame from which the variables are being extracted from.}

\item{paired}{Indicates whether the statistical test is a paired difference test.
By default, it is set to "F",which means the function will be an unpaired
statistical test comparing two independent groups.Inserting "paired" will
change the test to a paired difference test.}

\item{method}{By default this is turned off (set to "default"), but
allows for bootstrapping if "boot" is insertedinto the function call.}

\item{replicates}{Indicates how many bootstrap replicates are to be performed.
The defaultis currently 20000 but more may be desirable, especially to make
the functions more smooth.}

\item{steps}{Indicates how many consonance intervals are to be calculated at
various levels. For example, setting this to 100 will produce 100 consonance
intervals from 0 to 100. Setting this to 10000 will produce more consonance
levels. By default, it is set to 1000. Increasing the number substantially
is not recommended as it will take longer to produce all the intervals and
store them into a dataframe.}

\item{table}{Indicates whether or not a table output with some relevant
statistics should be generated. The default is TRUE and generates a table
which is included in the list object.}
}
\description{
Computes thousands of consonance (confidence) intervals for the chosen
parameter in a statistical test that compares means and places the interval
limits for each interval level into a data frame along with the corresponding
p-values and s-values.
}
\examples{

# Simulate random data
GroupA <- runif(100, min = 0, max = 100)
GroupB <- runif(100, min = 0, max = 100)
RandomData <- data.frame(GroupA, GroupB)
bob <- curve_mean(GroupA, GroupB, RandomData)
tibble::tibble(bob[[1]])
}
