% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_rows.R
\name{show_rows}
\alias{show_rows}
\alias{show_rows_}
\alias{show_rows}
\title{Selects the rows to be printed}
\usage{
show_rows(...)

show_rows_(..., .dots)
}
\arguments{
\item{...}{Comma separated list of unquoted extensions.}

\item{.dots}{Used to work around non-standard evaluation. See
\code{vignette("nse")} for details.}
}
\value{
A condformat_show_rows object, usually to be added to a condformat_tbl object
        as shown in the examples
}
\description{
Keeps the rows you mention in the printed table.
Compared to \code{\link[dplyr]{filter}}, show_rows does not remove the
rows from the actual data frame, they are removed only for printing.
}
\examples{
library(condformat)
data(iris)
x <- head(iris)
condformat(x) + show_rows(Sepal.Length > 4.5, Species == "setosa")
library(condformat)
data(iris)
x <- head(iris)
condformat(x) + show_rows_(.dots = c("Sepal.Length > 4.5", "Species == 'setosa'"))
}
\seealso{
\code{\link[dplyr]{filter}}
}
