% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{eval.config}
\alias{eval.config}
\title{Read from the currently active configuration (JSON/INI/YAML/TOML be supported), 
'retreiving either a single named value or all values as a config obj which 
have 'config', 'configtype', 'file' 'property.}
\usage{
eval.config(value = NULL, config = Sys.getenv("R_CONFIG_ACTIVE", "default"),
  file = Sys.getenv("R_CONFIGFILE_ACTIVE", "config.cfg"), ...)
}
\arguments{
\item{value}{Name of value (NULL to read all values)}

\item{config}{Name of configuration to read from. Defaults to the value of 
'the R_CONFIG_ACTIVE environment variable ('default' if the variable does not exist).}

\item{file}{File name of configuration file to read from. Defaults to the value of
the ‘R_CONFIGFILE_ACTIVE’ environment variable ('config.cfg' if the
variable does not exist and JSON/INI/YAML/TOML format only)}

\item{...}{Arguments for \code{\link{read.config}}}
}
\value{
Either a single value or all values as a list or 
logical FALSE indicating that is not standard JSON/INI/YAML/TOML format file
}
\description{
Read from the currently active configuration (JSON/INI/YAML/TOML be supported), 
'retreiving either a single named value or all values as a config obj which 
have 'config', 'configtype', 'file' 'property.
}
\examples{
config.json <- system.file('extdata', 'config.json', package='configr')
config <- eval.config(file=config.json)
config.extra.parsed.1 <- eval.config(file = config.json, extra.list = list(debug = "TRUE"))
other.config <- system.file('extdata', 'config.other.yaml', package='configr')
config.extra.parsed.2 <- eval.config(file = config.json, extra.list = list(debug = "TRUE"), 
other.config = other.config)
}
\seealso{
\code{\link{read.config}} read config by this 

\code{\link{eval.config.merge}} which can merge multiple parameter sets by groups
}
