% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_skew_and_kurtosis.R
\name{moment}
\alias{moment}
\title{Sample Moments}
\usage{
moment(z, p = 1, central = TRUE, na.rm = TRUE)
}
\arguments{
\item{z}{A numeric vector.}

\item{p}{Order of moment.}

\item{central}{Should central moment be calculated? Default is \code{TRUE}.}

\item{na.rm}{Logical flag indicating whether to remove missing values or not.
Default is \code{TRUE}.}
}
\value{
Numeric vector of length 1.
}
\description{
Calculates central or non-central sample moments.
}
\examples{
moment(1:10, p = 1)
moment(1:10, p = 1, central = FALSE)
moment(1:10, p = 2) / stats::var(1:10)
}
\seealso{
\code{\link{skewness}}, \code{\link{kurtosis}}.
}
