% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multisplit.R
\name{conformal.fun.msplit}
\alias{conformal.fun.msplit}
\title{Functional Multi Split Conformal Prediction Regions}
\usage{
conformal.fun.msplit(
  x,
  t,
  y_val,
  x0,
  train.fun,
  predict.fun,
  alpha = 0.1,
  split = NULL,
  seed = FALSE,
  randomized = FALSE,
  seed_beta = FALSE,
  verbose = FALSE,
  training_size = NULL,
  s_type,
  B = 100,
  lambda = 0,
  tau = 1 - (B + 1)/(2 * B)
)
}
\arguments{
\item{x}{The input variable, a list of n elements. Each element is composed by a list
of p vectors(with variable length, since the evaluation grid may change).}

\item{t}{The grid points for the evaluation of function y_val. It has the same
structure as x (list of list of vector).}

\item{y_val}{The response variable. It is either, as with x and t, a list of list of
vectors or an fda object (of type fd, fData, mfData).}

\item{x0}{The new points to evaluate, a list of n0 elements. Each element is composed
by a list of p vectors(with variable length).}

\item{train.fun}{A function to perform model training, i.e., to produce an
estimator of E(Y|X), the conditional expectation of the response variable
Y given features X. Its input arguments should be x: list of features,
and y: list of responses.}

\item{predict.fun}{A function to perform prediction for the (mean of the)
responses at new feature values. Its input arguments should be out: output
produced by train.fun, and newx: feature values at which we want to make
predictions.}

\item{alpha}{Miscoverage level for the prediction intervals, i.e., intervals
with coverage 1-alpha are formed. Default for alpha is 0.1.}

\item{split}{Indices that define the data-split to be used (i.e., the indices
define the first half of the data-split, on which the model is trained).
Default is NULL, in which case the split is chosen randomly.}

\item{seed}{Integer to be passed to set.seed before defining the random
data-split to be used. Default is FALSE, which effectively sets no seed.
If both split and seed are passed, the former takes priority and the latter
is ignored.}

\item{randomized}{Should the randomized approach be used? Default is FALSE.}

\item{seed_beta}{The seed for the randomized version of the conformal.split.fun.
Default is FALSE.}

\item{verbose}{Should intermediate progress be printed out? Default is FALSE.}

\item{training_size}{Vector containing the split proportion between training and calibration set.
It has B components. Default is 0.5.}

\item{s_type}{The type of modulation function.
Currently we have 3 options: "identity","st-dev","alpha-max".}

\item{B}{Number of repetitions. Default is 100.}

\item{lambda}{Smoothing parameter. Default is 0.}

\item{tau}{It is a smoothing parameter:
tau=1-1/B  Bonferroni intersection method
tau=0 unadjusted intersection
Default is 1-(B+1)/(2*B).}
}
\value{
A list of the following: lo,up,grid_size,tn.
}
\description{
Compute prediction regions using functional multi split conformal inference.
}
\details{
The work is an extension of the univariate approach to Multi Split
conformal inference to a multivariate functional context.

This function is based on the package future.apply to
 perform parallelisation. If this package is not installed, then the function
 will abort.
}
\examples{
# Here we will just test with y with fData type. A list of points or a mfData,
# or an fda type are still valid options as input.
# Please refer to the example for conformal.fun.split


## fData #############################

N = 30
P = 10
grid = seq( 0, 1, length.out = P )
C = roahd::exp_cov_function( grid, alpha = 0.3, beta = 0.4 )
values = roahd::generate_gauss_fdata( N,
                                      centerline = sin( 2 * pi * grid ),
                                      Cov = C )
fD = roahd::fData( grid, values )
x0=list(as.list(grid))
fun=mean_lists()
B=2

final.multi=conformal.fun.msplit(NULL,NULL, fD, x0, fun$train.fun, fun$predict.fun,
                                 alpha=0.1,
                                 split=NULL, seed=FALSE, randomized=FALSE,seed_beta=FALSE,
                                 verbose=FALSE, training_size=NULL,s_type="st-dev",B,lambda=0,
                                 tau = 0)

}
\references{
"Multi Split Conformal Prediction" by Solari, Djordjilovic (2021) is
the baseline for the univariate case.
}
