% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/full.R
\name{conformal.multidim.full}
\alias{conformal.multidim.full}
\title{Full Conformal Prediction Regions, Multivariate Response}
\usage{
conformal.multidim.full(
  x,
  y,
  x0,
  train.fun,
  predict.fun,
  alpha = 0.1,
  mad.train.fun = NULL,
  mad.predict.fun = NULL,
  score = "l2",
  s.type = "st-dev",
  num.grid.pts.dim = 100,
  grid.factor = 1.25,
  verbose = FALSE
)
}
\arguments{
\item{x}{Matrix of features, of dimension (say) n x p.}

\item{y}{Matrix of responses, of length (say) n X q.}

\item{x0}{Matrix of features, each row being a point at which we want to
form a prediction interval, of dimension (say) n0 x p.}

\item{train.fun}{A function to perform model training, i.e., to produce an
estimator of E(Y|X), the conditional expectation of the response variable
Y given features X. Its input arguments should be x: matrix of features,
y: vector of responses, and out: the output produced by a previous call
to train.fun, at the \emph{same} features x. The function train.fun may
(optionally) leverage this returned output for efficiency purposes. See
details below.}

\item{predict.fun}{A function to perform prediction for the (mean of the)
responses at new feature values. Its input arguments should be out: output
produced by train.fun, and newx: feature values at which we want to make
predictions.}

\item{alpha}{Miscoverage level for the prediction intervals, i.e., intervals
with coverage 1-alpha are formed. Default for alpha is 0.1.}

\item{mad.train.fun}{A function to perform training on the absolute residuals
i.e., to produce an estimator of E(R|X) where R is the absolute residual
R = |Y - m(X)|, and m denotes the estimator produced by train.fun.
This is used to scale the conformal score, to produce a prediction interval
with varying local width. The input arguments to mad.train.fun should be
x: matrix of features, y: vector of absolute residuals, and out: the output
produced by a previous call to mad.train.fun, at the \emph{same} features
x. The function mad.train.fun may (optionally) leverage this returned
output for efficiency purposes. See details below. The default for
mad.train.fun is NULL, which means that no training is done on the absolute
residuals, and the usual (unscaled) conformal score is used. Note that if
mad.train.fun is non-NULL, then so must be mad.predict.fun (next).}

\item{mad.predict.fun}{A function to perform prediction for the (mean of the)
absolute residuals at new feature values. Its input arguments should be
out: output produced by mad.train.fun, and newx: feature values at which we
want to make predictions. The default for mad.predict.fun is NULL, which
means that no local scaling is done for the conformal score, i.e., the
usual (unscaled) conformal score is used.}

\item{score}{Method to compute nonconformity measure in the multivariate regime.
The user can choose between squared l^2 norm of the residual,
mahalanobis depth of the residual, the max norm of the residual.}

\item{s.type}{The type of modulation function.
Currently we have 3 options: "identity","st-dev". Default is "st-dev"}

\item{num.grid.pts.dim}{Number of grid points per dimension used when forming the conformal
intervals (each num.grid.pts.dim^q points is a trial point). Default is
100.}

\item{grid.factor}{Expansion factor used to define the grid for the conformal
intervals, i.e., the grid points are taken to be equally spaced in between
-grid.factor x max(abs(y)) and grid.factor x max(abs(y)). Default is 1.25. In
this case (and with exchangeable data, thus unity weights) the restriction
of the trial values to this range costs at most 1/(n+1) in coverage. See
details below.}

\item{verbose}{Should intermediate progress be printed out? Default is FALSE.}
}
\value{
A list with the following components: pred, valid_points. The first
  is a matrix of dimension n0 x q, while the second is a list of length n0, containing in each
  position a matrix of varying number of rows (depending on which points where accepted by
  the method) and with a number of columns equal to q + 1. Indeed, valid_points contains the
  selected points on the y-grid as well as the p-values.
}
\description{
Compute prediction intervals using full conformal inference with multivariate
response
}
\details{
Due to eventual computational overload the function is restricted to a bivariate y.

This function is based on the package \code{\link{future.apply}} to
 perform parallelisation.

If the data (training and test) are assumed to be exchangeable, the basic
  assumption underlying conformal prediction, then the probability that a new
  response value will lie outside of (-max(abs(y)), max(abs(y))), where y is
  the vector of training responses, is 1/(n+1).  Thus the restriction of the
  trials values to (-grid.factor x max(abs(y)), grid.factor x max(abs(y))), for
  all choices grid.factor >= 1, will lead to a loss in coverage of at most
  1/(n+1). This was also noted in "Trimmed Conformal Prediction for
  High-Dimensional Models" by Chen, Wang, Ha, Barber (2016) <arXiv:1611.09933>
  (who use this basic fact as motivation for proposing more refined trimming methods).
}
\examples{
n=25
p=4
q=2


mu=rep(0,p)
x = mvtnorm::rmvnorm(n, mu)
beta<-sapply(1:q, function(k) c(mvtnorm::rmvnorm(1,mu)))
y = x\%*\%beta + t(mvtnorm::rmvnorm(q,1:n))
x0=x[ceiling(0.9*n):n,]
y0=y[ceiling(0.9*n):n,]

n0<-nrow(y0)
q<-ncol(y)


fun=mean_multi()

#################################### FULL CONFORMAL

final.full=conformal.multidim.full(x, y, x0, fun$train.fun,
                                fun$predict.fun, score="l2",
                                num.grid.pts.dim=5, grid.factor=1.25,
                                verbose=FALSE)

ppp<-plot_multidim(final.full)

}
\seealso{
\code{\link{conformal.multidim.split}}
}
