% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs.R
\name{connector_fs}
\alias{connector_fs}
\title{Create \code{fs} connector}
\usage{
connector_fs(path, extra_class = NULL)
}
\arguments{
\item{path}{\link{character} Path to the file storage.}

\item{extra_class}{\link{character} Extra class to assign to the new connector.}
}
\value{
A new \link{ConnectorFS} object
}
\description{
Initializes the connector for file system type of storage.
See \link{ConnectorFS} for details.
}
\details{
The \code{extra_class} parameter allows you to create a subclass of the
\code{ConnectorFS} object. This can be useful if you want to create
a custom connection object for easier dispatch of new s3 methods, while still
inheriting the methods from the \code{ConnectorFS} object.
}
\examples{
# Create FS connector
cnt <- connector_fs(tempdir())
cnt

# Create subclass connection
cnt_subclass <- connector_fs(
  path = tempdir(),
  extra_class = "subclass"
)
cnt_subclass
class(cnt_subclass)

}
