% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/largeVis.R
\name{buildWijMatrix}
\alias{buildWijMatrix}
\alias{buildWijMatrix.TsparseMatrix}
\alias{buildWijMatrix.CsparseMatrix}
\title{Rescale the weights in an edge matrix to match a given perplexity.}
\usage{
buildWijMatrix(x, threads = NULL, perplexity = 50)

\method{buildWijMatrix}{TsparseMatrix}(x, threads = NULL, perplexity = 50)

\method{buildWijMatrix}{CsparseMatrix}(x, threads = NULL, perplexity = 50)
}
\arguments{
\item{x}{A sparse matrix}

\item{threads}{numeric The maximum number of threads to spawn. Determined automatically if \code{NULL} (default=NULL)}

\item{perplexity}{numeric Given perplexity (default=50)}
}
\value{
A \code{list} with the following components: \describe{
   \item{'dist'}{An [N,K] matrix of the distances to the nearest neighbors.}
   \item{'id'}{An [N,K] matrix of the node indexes of the neartest neighbors.  Note that this matrix is 1-indexed,
   unlike most other matrices in this package.}
   \item{'k'}{The number of nearest neighbors.}
 }
}
\description{
Rescale the weights in an edge matrix to match a given perplexity.
}
