% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-tbl_df.R
\name{opts_tbl_df}
\alias{opts_tbl_df}
\title{Constructive options for tibbles}
\usage{
opts_tbl_df(
  constructor = c("tibble", "tribble", "next", "list"),
  ...,
  trailing_comma = TRUE
)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the environment, see Details section.}

\item{...}{Should not be used. Forces passing arguments by name.}

\item{trailing_comma}{Boolean, whether to leave a trailing comma at the end of the constructor call
calls}
}
\value{
An object of class <constructive_options/constructive_options_tbl_df>
}
\description{
These options will be used on objects of class 'tbl_df', also known as tibbles. .
}
\details{
Depending on \code{constructor}, we construct the object as follows:
\itemize{
\item \code{"tibble"} (default): Wrap the column definitions in a \code{tibble::tibble()} call.
\item \code{"tribble"} : We build the object using \code{tibble::tribble()} if possible, and fall
back to \code{tibble::tibble()}.
\item \code{"next"} : Use the constructor for the next supported class. Call \code{.class2()}
on the object to see in which order the methods will be tried.
\item \code{"list"} : Use \code{list()} and treat the class as a regular attribute.
}
}
