% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy_mab_ucb1.R
\name{UCB1Policy}
\alias{UCB1Policy}
\title{Policy: UCB1}
\description{
UCB policy for bounded bandits with a Chernoff-Hoeffding Bound
}
\details{
\code{UCB1Policy} constructs an optimistic estimate in the form of an Upper Confidence Bound to
create an estimate of the expected payoff of each action, and picks the action with the highest estimate.
If the guess is wrong, the optimistic guess quickly decreases, till another action has
the higher estimate.
}
\section{Usage}{

\preformatted{
policy <- UCB1Policy()
}
}

\section{Methods}{


\describe{
\item{\code{new()}}{ Generates a new \code{UCB1Policy} object.}
}

\describe{
\item{\code{set_parameters()}}{each policy needs to assign the parameters it wants to keep track of
to list \code{self$theta_to_arms} that has to be defined in \code{set_parameters()}'s body.
The parameters defined here can later be accessed by arm index in the following way:
\code{theta[[index_of_arm]]$parameter_name}
}
}

\describe{
\item{\code{get_action(context)}}{
here, a policy decides which arm to choose, based on the current values
of its parameters and, potentially, the current context.
}
}

\describe{
\item{\code{set_reward(reward, context)}}{
in \code{set_reward(reward, context)}, a policy updates its parameter values
based on the reward received, and, potentially, the current context.
}
}
}

\examples{
\dontrun{

horizon            <- 100L
simulations        <- 100L
weights            <- c(0.9, 0.1, 0.1)

policy             <- UCB1Policy$new()
bandit             <- BasicBernoulliBandit$new(weights = weights)
agent              <- Agent$new(policy, bandit)

history            <- Simulator$new(agent, horizon, simulations, do_parallel = FALSE)$run()

plot(history, type = "cumulative")

plot(history, type = "arms")

}
}
\references{
Lai, T. L., & Robbins, H. (1985). Asymptotically efficient adaptive allocation rules. Advances in applied
mathematics, 6(1), 4-22.
}
\seealso{
Core contextual classes: \code{\link{Bandit}}, \code{\link{Policy}}, \code{\link{Simulator}},
\code{\link{Agent}}, \code{\link{History}}, \code{\link{Plot}}

Bandit subclass examples: \code{\link{BasicBernoulliBandit}}, \code{\link{ContextualLogitBandit}},
\code{\link{OfflineReplayEvaluatorBandit}}

Policy subclass examples: \code{\link{EpsilonGreedyPolicy}}, \code{\link{ContextualLinTSPolicy}}
}
