% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FisherFreemanHalton_asymptotic_test_rxc.R
\name{FisherFreemanHalton_asymptotic_test_rxc}
\alias{FisherFreemanHalton_asymptotic_test_rxc}
\title{The Fisher-Freeman-Halton asymptotic test for unordered rxc tables}
\usage{
FisherFreemanHalton_asymptotic_test_rxc(n, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (an rxc matrix)}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing the probability, the statistic and the degrees of freedom
}
\description{
The Fisher-Freeman-Halton asymptotic test for unordered rxc tables

Described in Chapter 7 "The rxc Table"
}
\note{
May not give results for all tables, due to overflow
}
\examples{
# Treatment for ear infection (van Balen et al., 2003)
n <- rbind(c(40, 25), c(54, 7), c(63, 10))
FisherFreemanHalton_asymptotic_test_rxc(n)

}
