% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arcsine_CI_1x2.R
\name{Arcsine_CI_1x2}
\alias{Arcsine_CI_1x2}
\title{Arcsine confidence interval}
\usage{
Arcsine_CI_1x2(X, n, alpha = 0.05)
}
\arguments{
\item{X}{the number of successes}

\item{n}{the total number of observations}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Arcsine confidence interval for the binomial probability
(with Anscombe variance stabilizing transformation)
Described in Chapter 2 "The 1x2 Table and the Binomial Distribution"
}
\examples{
Arcsine_CI_1x2(singh_2010["1st", "X"], singh_2010["1st", "n"])
Arcsine_CI_1x2(singh_2010["2nd", "X"], singh_2010["2nd", "n"])
Arcsine_CI_1x2(singh_2010["3rd", "X"], singh_2010["3rd", "n"])
with(singh_2010["4th", ], Arcsine_CI_1x2(X, n)) # alternative syntax
Arcsine_CI_1x2(ligarden_2010["X"], ligarden_2010["n"])
}
\references{
Anscombe FJ (1948) The transformation of Poisson, binomial and
negative binomial data. Biometrika; 35:246-254
}
