% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_country.R
\name{check_country}
\alias{check_country}
\title{Check a dataset (tibble) for the presence of countries}
\usage{
check_country(myTB, clusterCode = "EU27")
}
\arguments{
\item{myTB}{dataset (tibble) to be checked}

\item{clusterCode}{string to denote  which countries should be in the dataset}
}
\value{
TRUE if they are inside, FALSE otherwise
}
\description{
A given list of countries is contained into a dataset (tibble).
If not, an object  signaling this error is returned.
}
\examples{

# Check the dataset "emp_20_64_MS" for the presence of countries in cluster EU27:
check_country(emp_20_64_MS, clusterCode="EU27")

# Check absence for EU27:
check_country(emp_20_64_MS[,-(6:8)], clusterCode="EU27")

# Check the dataset "emp_20_64_MS" for the presence of countries in cluster EU25:
check_country(emp_20_64_MS, clusterCode="EU25")

# Check the dataset "emp_20_64_MS" for the presence of countries in cluster EU12:
check_country(emp_20_64_MS, clusterCode="EU12")

}
\references{
{ \url{https://local.disia.unifi.it/stefanini/RESEARCH/coneu/tutorial-conv.html}}
}
