% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyzenga.R
\name{svyzenga}
\alias{svyzenga}
\alias{svyzenga.survey.design}
\alias{svyzenga.svyrep.design}
\alias{svyzenga.DBIsvydesign}
\title{Zenga index (EXPERIMENTAL)}
\usage{
svyzenga(formula, design, ...)

\method{svyzenga}{survey.design}(formula, design, na.rm = FALSE, ...)

\method{svyzenga}{svyrep.design}(formula, design, na.rm = FALSE, ...)

\method{svyzenga}{DBIsvydesign}(formula, design, ...)
}
\arguments{
\item{formula}{a formula specifying the income variable.}

\item{design}{a design object of class \code{survey.design} or class \code{svyrep.design} from the \code{survey} library.}

\item{...}{future expansion}

\item{na.rm}{Should cases with missing values be dropped?}
}
\value{
Object of class "\code{cvystat}", which are vectors with a "\code{var}" attribute giving the variance and a "\code{statistic}" attribute giving the name of the statistic.
}
\description{
Estimate the Zenga index, a measure of inequality
}
\details{
you must run the \code{convey_prep} function on your survey design object immediately after creating it with the \code{svydesign} or \code{svrepdesign} function.
}
\note{
This function is experimental and is subject to changes in later versions.
}
\examples{
library(survey)
library(laeken)
data(eusilc) ; names( eusilc ) <- tolower( names( eusilc ) )

# linearized design
des_eusilc <- svydesign( ids = ~rb030 , strata = ~db040 ,  weights = ~rb050 , data = eusilc )
des_eusilc <- convey_prep(des_eusilc)

# replicate-weighted design
des_eusilc_rep <- as.svrepdesign( des_eusilc , type = "bootstrap" )
des_eusilc_rep <- convey_prep(des_eusilc_rep)


# variable without missing values
svyzenga(~eqincome, des_eusilc)
svyzenga(~eqincome, des_eusilc_rep)

# subsetting:
svyzenga(~eqincome, subset( des_eusilc, db040 == "Styria"))
svyzenga(~eqincome, subset( des_eusilc_rep, db040 == "Styria"))

\dontrun{

# variable with with missings
svyzenga(~py010n, des_eusilc )
svyzenga(~py010n, des_eusilc_rep )

svyzenga(~py010n, des_eusilc, na.rm = TRUE )
svyzenga(~py010n, des_eusilc_rep, na.rm = TRUE )

# database-backed design
library(RSQLite)
library(DBI)
dbfile <- tempfile()
conn <- dbConnect( RSQLite::SQLite() , dbfile )
dbWriteTable( conn , 'eusilc' , eusilc )

dbd_eusilc <-
	svydesign(
		ids = ~rb030 ,
		strata = ~db040 ,
		weights = ~rb050 ,
		data="eusilc",
		dbname=dbfile,
		dbtype="SQLite"
	)

dbd_eusilc <- convey_prep( dbd_eusilc )


# variable without missing values
svyzenga(~eqincome, dbd_eusilc)

# subsetting:
svyzenga(~eqincome, subset( dbd_eusilc, db040 == "Styria"))

# variable with with missings
svyzenga(~py010n, dbd_eusilc )

svyzenga(~py010n, dbd_eusilc, na.rm = TRUE )


dbRemoveTable( conn , 'eusilc' )

dbDisconnect( conn , shutdown = TRUE )

}

}
\references{
Lucio Barabesi, Giancarlo Diana and Pier Francesco Perri (2016). Linearization of inequality indexes in the design-based framework.
Statistics. URL \url{https://www.tandfonline.com/doi/pdf/10.1080/02331888.2015.1135924}.

Matti Langel (2012). Measuring inequality in finite population sampling.
PhD thesis: Universite de Neuchatel,
URL \url{https://doc.rero.ch/record/29204/files/00002252.pdf}.
}
\seealso{
\code{\link{svygini}}
}
\author{
Guilherme Jacob, Djalma Pessoa and Anthony Damico
}
\keyword{survey}
