% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requests.R
\name{extract_cookie}
\alias{extract_cookie}
\title{Extract an individual cookie from a shiny request}
\usage{
extract_cookie(request, cookie_name)
}
\arguments{
\item{request}{A shiny request object.}

\item{cookie_name}{The name of the cookie. Can contain any US-ASCII
characters except for: the control character, space, a tab, or separator
characters like ( ) < > @ , ; : \\ " / [ ] ? = \{ \}.}
}
\value{
The contents of that cookie.
}
\description{
The shiny request object includes any cookies that are available to the app.
This function extracts the value of a named cookie from that request.
}
\examples{
req <- list(HTTP_COOKIE = "cookie1=expected_value; cookie2=1; cookie3=2")
extract_cookie(req, "cookie1")
extract_cookie(req, "cookie2")
extract_cookie(list(), "cookie1")
extract_cookie(NULL, "cookie1")
}
