% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approxfun2.R
\name{approxfun2}
\alias{approxfun2}
\title{Bilinear interpolation function of data on a regular grid}
\usage{
approxfun2(x, y, z, outside = NA)
}
\arguments{
\item{x}{vector of x-coordinates; must be strictly monotonically increasing, but not necessarily equally spaced}

\item{y}{vector of y-coordinates; must be strictly monotonically increasing, but not necessarily equally spaced}

\item{z}{matrix of dimension c(length(x),length(y)) containing the function values to be interpolated}

\item{outside}{value of the approximation function outside the grid (default is NA)}
}
\value{
Returns a fast an vectorized interpolation function f(x,y)
}
\description{
Generates a fast function f(x,y) that interpolates regularly gridded data, based on the equivalent subroutine \code{\link[stats]{approxfun}} in 1D.
}
\examples{
x = seq(3)
y = seq(4)
z = array(c(x+1,x+2,x+3,x+4),c(3,4))
f = approxfun2(x,y,z)
print(f(1.7,2.4))

}
\seealso{
\code{\link[stats]{approxfun}}
}
\author{
Danail Obreschkow
}
