/*
 * Decompiled with CFR 0.152.
 */
package uno.informatics.data.feature;

import java.util.List;
import uno.informatics.data.DataType;
import uno.informatics.data.Feature;
import uno.informatics.data.Method;
import uno.informatics.data.ScaleType;
import uno.informatics.data.feature.ColumnFeature;
import uno.informatics.data.pojo.EntityPojo;
import uno.informatics.data.pojo.MethodPojo;
import uno.informatics.data.pojo.ScalePojo;
import uno.informatics.data.utils.DatasetUtils;

public class ColumnFeaturePojo
extends EntityPojo
implements ColumnFeature {
    private static final long serialVersionUID = 1L;
    private DataType dataType = DataType.STRING;
    private ScaleType scaleType = ScaleType.NOMINAL;
    private ScalePojo scale;
    private MethodPojo method;
    private int possibleDataTypes;

    public ColumnFeaturePojo(String name, DataType dataType, ScaleType scaleType, int possibleDataTypes) {
        super(name);
        this.scale = new ScalePojo(name);
        this.method = new MethodPojo(name, this.scale);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setPossibleDataTypes(possibleDataTypes);
    }

    public ColumnFeaturePojo(String uniqueIdentifier, String name, DataType dataType, ScaleType scaleType, int possibleDataTypes) {
        super(uniqueIdentifier, name);
        this.scale = new ScalePojo(name);
        this.method = new MethodPojo(name, this.scale);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setPossibleDataTypes(possibleDataTypes);
    }

    public ColumnFeaturePojo(String uniqueIdentifier, String name, String description, DataType dataType, ScaleType scaleType, int possibleDataTypes) {
        super(uniqueIdentifier, name, description);
        this.scale = new ScalePojo(name);
        this.method = new MethodPojo(name, this.scale);
        this.setDataType(dataType);
        this.setScaleType(scaleType);
        this.setPossibleDataTypes(possibleDataTypes);
    }

    public ColumnFeaturePojo(Feature feature) {
        super(feature);
        this.method = new MethodPojo(feature.getMethod());
        this.scale = (ScalePojo)this.method.getScale();
        this.setDataType(this.scale.getDataType());
        this.setScaleType(this.scale.getScaleType());
        this.setPossibleDataTypes(this.possibleDataTypes);
    }

    public ColumnFeaturePojo(String name, int possibleDataTypes) {
        super(name);
        this.scale = new ScalePojo(name);
        this.method = new MethodPojo(name, this.scale);
        this.setPossibleDataTypes(possibleDataTypes);
    }

    public ColumnFeaturePojo(String uniqueIdentifier, String name, int possibleDataTypes) {
        super(uniqueIdentifier, name);
        this.scale = new ScalePojo(name);
        this.method = new MethodPojo(name, this.scale);
        this.setPossibleDataTypes(possibleDataTypes);
    }

    public ColumnFeaturePojo(String uniqueIdentifier, String name, String description, int possibleDataTypes) {
        super(uniqueIdentifier, name, description);
        this.scale = new ScalePojo(name);
        this.method = new MethodPojo(name, this.scale);
        this.setPossibleDataTypes(possibleDataTypes);
    }

    @Override
    public int getPossibleDataTypes() {
        return this.possibleDataTypes;
    }

    @Override
    public void setPossibleDataTypes(int possibleDataTypes) {
        this.possibleDataTypes = possibleDataTypes;
        List<DataType> dataTypes = DatasetUtils.getDataTypes(possibleDataTypes);
        if (!(dataTypes.isEmpty() || this.getDataType() != DataType.UNKNOWN && dataTypes.contains((Object)this.getDataType()))) {
            this.setDataType(dataTypes.get(0));
        }
        if (this.getDataType() != DataType.UNKNOWN) {
            List<ScaleType> scaleTypes = DatasetUtils.getScaleTypes(this.getDataType());
            if (this.getScaleType() == ScaleType.NONE || !scaleTypes.contains((Object)this.getScaleType())) {
                this.setScaleType(scaleTypes.get(0));
            }
        } else {
            this.setScaleType(ScaleType.NONE);
        }
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public final DataType getDataType() {
        return this.dataType;
    }

    public final void setDataType(DataType dataType) {
        this.dataType = dataType;
        this.getScale().setDataType(dataType);
    }

    @Override
    public final ScaleType getScaleType() {
        return this.scaleType;
    }

    public final void setScaleType(ScaleType scaleType) {
        this.scaleType = scaleType;
        this.getScale().setScaleType(scaleType);
    }

    public ScalePojo getScale() {
        return this.scale;
    }
}

