% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_contexts.r
\name{tCorpus$subset_query}
\alias{tCorpus$subset_query}
\alias{subset_query}
\title{Subset tCorpus token data using a query}
\arguments{
\item{query}{A character string that is a query. See \link{tCorpus$search_contexts} for query syntax.}

\item{feature}{The name of the feature columns on which the query is used.}

\item{context_level}{Select whether the query and subset are performed at the document, sentence or (token)window level. If window is selected, the window size is specified in the window argument}

\item{window}{if context_level is window, specifies the size of the window}
}
\description{
A convenience function that searches for contexts (documents, sentences), and uses the results to \link[=tCorpus$search_contexts]{subset} the tCorpus token data.

See the documentation for \link[=tCorpus$search_contexts]{subset} for an explanation of the query language.

\strong{Usage:}

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{subset_query(query, feature = 'token', context_level = c('document','sentence'))}
}
\examples{
text = c('A B C', 'D E F. G H I', 'A D', 'GGG')
tc = create_tcorpus(text, doc_id = c('a','b','c','d'), split_sentences = TRUE)

## subset by reference
tc$subset_query('A')
tc$get_meta()

## using copy mechanic
tc2 = tc$subset_query('A AND D', copy=TRUE)

tc2$get_meta()

tc$get_meta() ## (unchanged)
}
