% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lda.r
\name{tCorpus$lda_fit}
\alias{tCorpus$lda_fit}
\alias{lda_fit}
\title{Estimate a LDA topic model}
\arguments{
\item{feature}{the name of the feature columns}

\item{create_feature}{optionally, add a feature column that indicates the topic to which a feature was assigned (in the last iteration). Has to be a character string, that will be the name of the new feature column}

\item{K}{the number of clusters}

\item{num.iterations}{the number of iterations}

\item{method}{set method. see documentation for LDA function of the topicmodels package}

\item{alpha}{the alpha parameter}

\item{eta}{the eta parameter#'}

\item{burnin}{The number of burnin iterations}
}
\value{
A fitted LDA model, and optionally a new column in the tcorpus (added by reference)
}
\description{
Estimate an LDA topic model using the LDA function from the topicmodels package.
The parameters other than dtm are simply passed to the sampler but provide a workable default.
See the description of that function for more information

\strong{Usage:}

## R6 method for class tCorpus. Use as tc$method (where tc is a tCorpus object).

\preformatted{
lda_fit(feature, create_feature=NULL, K=50, num.iterations=500, alpha=50/K,
     eta=.01, burnin=250, context_level=c('document','sentence'), ...)
}
}
\examples{
\donttest{
tc = create_tcorpus(sotu_texts, doc_column = 'id')
tc$preprocess('token', 'feature', remove_stopwords = TRUE, use_stemming = TRUE, min_freq=10)
set.seed(1)
m = tc$lda_fit('feature', create_feature = 'lda', K = 5, alpha = 0.1)

m
topicmodels::terms(m, 10)
tc$tokens
}
}
