% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covastat.R
\docType{class}
\name{covastat-class}
\alias{covastat-class}
\alias{covastat}
\title{Class "covastat"}
\usage{
covastat(matdata, stpairs, typetest = 0)
}
\arguments{
\item{matdata}{STFDF/STSDF or \code{data frame}; which contains the
coordinates of the spatial points, the identification code of the spatial
points, the indentification code of the temporal points and the values of
the variable}

\item{stpairs}{object of class \code{couples}, containing the spatial
points and the corresponding temporal lags to be analyzed}

\item{typetest}{integer; set \code{typetest=0} for symmetry test (default
choice), \code{typetest=1} for separability test, \code{typetest=2} for type
of non separability test, \code{typetest=3} for the test on the product-sum
class of models, \code{typetest=4} for the test on the integrated product
class of models, \code{typetest=5} for the test on the Gneiting class of
models}
}
\description{
A class for the sample spatio-temporal covariances for the specified spatial
and temporal lags, given in \code{stpairs} (object of class \code{couple}).
Depending on the type of test, the empirical variance, the sample spatial
and temporal marginal covariances are also computed.
}
\details{
The function requires the user to set some external arguments. In particular,
if the spatio-temporal data are given as a \code{data} \code{frame} it is
necessary to specify
\itemize{
\item the column in which the spatial ID is stored
\item the column in which the values of the variable are stored.
}
On the other hand, if the data are given as a STFDF/STSDF it is necessary to
specify
\itemize{
\item the number of variables in the STFDF/STSDF
\item the slot in which the values of the variable of interest are stored
(only if more than one variable is stored in the STFDF/STSDF).
} Note that a message appears on the user's console if the \code{G} vector
contains spatio-temporal negative covariances. The message returns the negative
value/values and it will help to identify the spatial and and the temporal lags
involved.
}
\section{Slots}{

\describe{
\item{\code{G}}{matrix; containing the spatio-temporal covariances for the specified
lags. For all tests, except for the symmetry test (\code{typetest=0}), the
sample variance and the sample spatial and temporal marginal covariances are
also computed and stored in \code{G}}

\item{\code{cova.h}}{matrix; containing the sample spatial marginal covariances
for the specified lags}

\item{\code{cova.u}}{matrix; containing the sample temporal marginal covariances
for the specified lags}

\item{\code{f.G}}{array; containing the computation of specific functions of the
elements of \code{G}, see references}

\item{\code{B}}{matrix; containing the computation of the derivatives of each element
of \code{f.G} with respect to each element of \code{G}}

\item{\code{A}}{contrast matrix}
}}

\note{
A stop occurs if the number of spatial points fixed in \code{stpairs}
 (object of class \code{couples}) is less than 2
}
\examples{
## The function requires to set some external arguments. In this example, it
# is only necessary to specify the number of variables in the STFDF (rr_13).
#
# To run the example, paste and copy the following lines
# (without the symbol '#') in the console
#
# coupl_sim <- couples(typetest = 0, typecode = character())
# blocks_sim <- blocks(lb = 40, ls = 10, matdata = rr_13, stpairs = coupl_sim)
# covabl_sim <- covablocks(stblocks = blocks_sim, stpairs = coupl_sim, typetest = 0)
# covast_sim <- covastat(matdata = rr_13, stpairs = coupl_sim, typetest = 0)
# 1

}
\references{
Li, B., Genton, M.G., Sherman, M., 2007, A nonparametric assessment
of properties of spacetime covariance functions.
Journal of the American Statistical Association, \bold{102} 736--744.

De Iaco, S., Palma, M., Posa, D., 2016. A general procedure for selecting a
class of fully symmetric space-time covariance functions.
Environmentrics, \bold{27(4)} 212--224.

Cappello, C., De Iaco, S., Posa, D., 2016, Testing the type of
non-separability and some classes of covariance models for space-time data.
Stochastic Environmental Research and Risk Assessment,
doi 10.1007/s00477-017-1472-2
}
\seealso{
\linkS4class{couples}

\code{\link{dataprep}}
}
