% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_emissions_manure.R
\name{calc_emissions_manure}
\alias{calc_emissions_manure}
\title{Calculate manure management emissions (Tier 1 & Tier 2)}
\usage{
calc_emissions_manure(
  n_cows,
  manure_system = "pasture",
  tier = 1L,
  ef_ch4 = NULL,
  n_excreted = 100,
  ef_n2o_direct = 0.02,
  include_indirect = FALSE,
  climate = "temperate",
  avg_body_weight = 600,
  diet_digestibility = 0.65,
  protein_intake_kg = NULL,
  retention_days = NULL,
  system_temperature = NULL,
  gwp_ch4 = 27.2,
  gwp_n2o = 273,
  boundaries = NULL
)
}
\arguments{
\item{n_cows}{Numeric scalar > 0. Number of dairy cows.}

\item{manure_system}{Character. One of "pasture", "solid_storage",
"liquid_storage", "anaerobic_digester". Default = "pasture".}

\item{tier}{Integer. IPCC tier (1 or 2). Default = 1.}

\item{ef_ch4}{Numeric. CH4 EF (kg CH4/cow/year). If \code{NULL}, system-specific
defaults are used (Tier 1 only).}

\item{n_excreted}{Numeric. N excreted per cow per year (kg N). Default = 100.
In Tier 2 it may be recalculated if protein intake is provided.}

\item{ef_n2o_direct}{Numeric. Direct N2O-N EF (kg N2O-N per kg N). Default = 0.02.}

\item{include_indirect}{Logical. Include indirect N2O (volatilization + leaching)?
Default = FALSE.}

\item{climate}{Character. One of "cold", "temperate", "warm". Default = "temperate" (Tier 2).}

\item{avg_body_weight}{Numeric. Average live weight (kg). Default = 600 (Tier 2).}

\item{diet_digestibility}{Numeric in (0, 1]. Apparent digestibility. Default = 0.65 (Tier 2).}

\item{protein_intake_kg}{Numeric. Daily protein intake (kg/day). If provided,
Tier 2 can refine N excretion.}

\item{retention_days}{Numeric. Days manure remains in system (Tier 2 adjustment).}

\item{system_temperature}{Numeric. Average system temperature (Tier 2 adjustment).}

\item{gwp_ch4}{Numeric. GWP for CH4 (AR6). Default = 27.2.}

\item{gwp_n2o}{Numeric. GWP for N2O (AR6). Default = 273.}

\item{boundaries}{Optional list from \code{set_system_boundaries()}.}
}
\value{
A list with CH4 (kg), N2O (kg), CO2eq (kg), metadata, and per-cow metrics.
The returned object includes a \code{co2eq_kg} field compatible with
\code{calc_total_emissions()}.
}
\description{
Estimates CH4 and N2O emissions from manure management using IPCC Tier 1
or Tier 2 methodology with practical settings for dairy systems.
}
\details{
Tier 2 uses a simplified VS–B0–MCF calculation with coarse temperature and
retention-time adjustments intended for examples and screening. For policy or
inventory reporting, replace defaults with jurisdiction-specific factors and
methods (e.g., country inventory guidelines).
}
\examples{
# Minimal, fast example (Tier 1, runs <1s)
calc_emissions_manure(n_cows = 100, manure_system = "solid_storage")

\donttest{
# Tier 1 with indirect N2O
calc_emissions_manure(
  n_cows = 120, manure_system = "solid_storage", include_indirect = TRUE
)

# Tier 2 (VS_B0_MCF approach) with refinements
calc_emissions_manure(
  n_cows = 100, manure_system = "liquid_storage", tier = 2,
  avg_body_weight = 580, diet_digestibility = 0.68, climate = "temperate",
  protein_intake_kg = 3.2, include_indirect = TRUE
)

# Boundaries exclusion example: "manure" not included -> co2eq_kg = 0
b <- list(include = c("enteric","soil","energy","inputs"))  # manure excluded
calc_emissions_manure(n_cows = 80, boundaries = b)$co2eq_kg  # 0
}
}
\references{
Intergovernmental Panel on Climate Change (2019). 2019 Refinement to the 2006
IPCC Guidelines for National Greenhouse Gas Inventories.
\url{https://www.ipcc-nggip.iges.or.jp/public/2019rf/}

International Dairy Federation (2022). "The IDF Global Carbon Footprint Standard
for the Dairy Sector." Bulletin of the IDF No. 520. \url{https://fil-idf.org/}
}
