#' @title Animals
#'
#' @description Named vector of animals
#'
#' @details `animals` is a named character vector of animals,
#' with each element a character string of variable length specifying
#' an ASCII animal. Note that some have unicode characters that won't
#' play well on some operating systems.
#' @export
#' @examples
#' cat(animals['cow'])
#' cat(animals['chicken'])
#' cat(animals[['chuck']])
#' cat(animals[['clippy']])
#' cat(animals[['poop']])
#' cat(animals[['bigcat']])
#' for (animal in animals) cat(animal, sep = "\n")
animals <- c(
  cow = "\n        ^__^ \n        (oo)\\\ ________ \n        (__)\\\         )\\\ /\\\ \n             ||------w|\n             ||      ||"
  ,cow_borg = "\n        ^__^ \n        (==)\\\ ________ \n        (__)\\\         )\\\ /\\\ \n             ||------w|\n             ||      ||"
  ,cow_greedy = "\n        ^__^ \n        ($$)\\\ ________ \n        (__)\\\         )\\\ /\\\ \n             ||------w|\n             ||      ||"
  ,cow_sleepy = "\n        ^__^ \n        (**)\\\ ________ \n        (__)\\\         )\\\ /\\\ \n         U   ||------w|\n             ||      ||"
  ,cow_dead = "\n        ^__^ \n        (xx)\\\ ________ \n        (__)\\\         )\\\ /\\\ \n         U   ||------w|\n             ||      ||"
  ,cow_tired = "\n        ^__^ \n        (--)\\\ ________ \n        (__)\\\         )\\\ /\\\ \n             ||------w|\n             ||      ||"
  ,cow_wired = "\n        ^__^ \n        (OO)\\\ ________ \n        (__)\\\         )\\\ /\\\ \n             ||------w|\n             ||      ||"
  ,cow_young = "\n        ^__^ \n        (..)\\\ ________ \n        (__)\\\         )\\\ /\\\ \n             ||------w|\n             ||      ||"
  ,chicken =
"         _
       _/ }
      `>' \\\
      `|   \\\
       |   /'-.     .-.
        \\\'     ';`--' .'
         \\\'.    `'-./
          '.`-..-;`
            `;-..'
            _| _|
            /` /` [nosig]
 "
 ,chuck =
"\n
                      @@@@@@@@@@@@@@
                   @@@@@@@@@@@@@@@@@@@@@@
                  @@@@@@@@@@@@@@@@@@@@@@@@@
                  @@@@@@@@@@@@@@@@@@@@@@@@@@
                  @@@@@@@@@@@@@@@@@@@@@@@@@@
                 @@@@@@@@@@@@@@@@@@@@@@@@@@@
                 @@@@@@@@@@@@@@@@@@@@@@@@@@@@
                @@@@@@@@@@@@@@@@@@@@@@@@@@@@@
                @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
               @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
 @             @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
  @@           @@@@@@@@@@@@@@@@@@     @@@@@@@@@@@@@@@@@@@@@
    @@@@@@@@@@@@@@@@    @@ @@@@         @@  @@@@@@@@@@@@@@@
       @@@@@@@@@@@@@      @@@@          @@@@@@@@@@@@@@@@@@@
          @@@@@@ @@@@@    @@@   @       @@@@@@@@@@ @@@@@@@
              @@     @ @                @@ @@@@@@@@   @@@
                                              @@@@@@@  @
                @     @@                   @ @@@@@@@@@
                             @               @@@@@@@@ @@
                     @@@@@@@@@@          @  @@@@@
                  @@@@@@@@@@ @@           @@@@@  @
                 @@@@        @@ @          @@@  @
                  @@@           @          @@@
                   @@@@@@@   @@ @          @@@@@
                    @@@@@@@@@@            @@@@
                     @@@@@@ @     @     @@@@@@@@
                  @@ @ @@@@@@@@@ @@@@@@@@@@@@@@@@@
                @@@  @@@@@   @@@@@@@@@@@@@@@@@@@@@
      @@@@@@  @@@@@   @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
@@    @@@@  @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ [nosig]
  "
  ,clippy = "
    _
   / \\
   | |
   @ @
  || ||
  || ||
  |\\_/|
  \\___/ GB
"
  ,poop =
"
     (   )
  (   ) (
   ) _   )
    ( \\_
  _(_\\\ \\)__
 (____\\\ ___)) [nosig]"

  ,bigcat =
"
                \\`*-.
                 )  _`-.
                .  : `. .
                : _   '  \\
                ; *` _.   `*-._
                `-.-'          `-.
                  ;       `       `.
                  :.       .       \\
                  .\\  .   :   .-'   .
                  '  `+.;  ;  '      :
                  :  '  |    ;       ;-.
                  ; '   : :`-:     _.`* ;
               .*' /  .*' ; .*`- +'  `*'
     [bug]     `*-*   `*-*  `*-*'
    "
    ,ant =
"
       '\\__
      (o )     ___
      <>(_)(_)(___)
        < < > >
        ' ' ` `  [nosig]
  "

  ,pumpkin =
"
                  ___
               ___)__|_
          .-*'          '*-,
         /      /|   |\\\     \\\
        ;      /_|   |_\\\     ;
        ;   |\\\           /|  ;
        ;   | ''--...--'' |  ;
         \\\  ''---.....--''  /
          ''*-.,_______,.-*'  [nosig]
  "

  ,ghost =
"
     .-.
    (o o)
    | O \\\
     \\\   \\\
      `~~~' [nosig]
  "

  ,spider =
"
              |
              |
              |
             __
          | /  \\\ |
         \\_\\\\  //_/
          .'/()\\\'.
           \\\\\  //  [nosig]
  "

  ,rabbit =
"
      ( )_( )
      (='.'=)
      (^)_(^) [nosig]
  "

  ,pig =
"
       _//| .-~~~-.
     _/oo  }       }-@
    ('')_  }       |
     `--'| { }--{  }
          //_/  /_/ [nosig]
  "

  ,snowman =
'
     _[_]_
      (")
  >--( : )--<
    (__:__) [nosig]
  '

  ,frog =
"
        (.)_(.)
     _ (   _   ) _
    / \\/`-----'\\/ \\
  __\\ ( (     ) ) /__
  )   /\\ \\._./ /\\   (
   )_/ /|\\   /|\\ \\_(  [nosig]
  "

  # From here:
  # http://chris.com/ascii/index.php?art=television/futurama
  ,hypnotoad =
"
                ,'``.._   ,'``.
                :,--._:)\\,:,._,.:
                :`--,''   :`...';\\
               `,'       `---'  `.
               /                 :
              /                   \\
            ,'                     :\\.___,-.
           `...,---'``````-..._    |:       \\
             (                 )   ;:    )   \\  _,-.
              `.              (   //          `'    \\
               :               `.//  )      )     , ;
             ,-|`.            _,'/       )    ) ,' ,'
            (  :`.`-..____..=:.-':     .     _,' ,'
             `,'\\ ``--....-)='    `._,  \\  ,') _ '``._
          _.-/ _ `.       (_)      /     )' ; / \\ \\`-.'
         `--(   `-:`.     `' ___..'  _,-'   |/   `.)
             `-. `.`.``-----``--,  .'
               |/`.\\`'        ,','); SSt
                   `         (/  (/
  "

  # From here:
  # https://twitter.com/BoingBoing/status/465170473194512384
  ,shortcat =
'
    .\uFF8A,,\uFF8A
    ( \uFF9F\u03C9\uFF9F)
    |\u3064  \u3064
    U " U
        [BoingBoing]
    '

  ,longcat =
'
    .\uFF8A,,\uFF8A
    ( \uFF9F\u03C9\uFF9F)
    |\u3064  \u3064
%s
    U "  U
        [BoingBoing]
    '

  ,fish =
'
  ><((((\u00BA>  ><((((\u00BA>  ><((((\u00BA>  ><((((\u00BA>  ><((((\u00BA>
      Kiyoko Gotanda
    '

  ,signbunny =
    '
(\\__/) ||
(\u2022\u3145\u2022) ||
/   \u3065
          [nosig]
    '

  ,facecat =
  '
         /\\\ /\\\
         (O o)
        =(:^:)=
           U      [nosig]
  '

  ,behindcat =
  '
            \u007c\u005c___/\u007c
            )     (
           =\\\     /=
             )===(
            /     \u005c
            |     |
           /       \u005c
           \u005c       /
      jgs   \u005c__  _/
              ( (
               ) )
              (_(
  '

  ,stretchycat =
  '
                        ,/\u007c         _.--\u201B\u201B^``-...___.._.,;
                      /, \u005c\u201B.     _-\u201B          ,--,,,--\u201B\u201B\u201B
                     {  \u005c    `_-\u201B\u201B       \u201B    /}\u201B
Jill                    `;;\u201B             ;   ; ;
                  ._.--\u201B\u201B     ._,,, _..\u201B  .;.\u201B
                  (,_....----\u201B\u201B\u201B     (,..--\u201B\u201B
  '

  ,anxiouscat =
  '
        /\u005c_/\u005c         _
       /``   \u005c       / )
       \u007cn n   \u007c__   ( (
      =(Y =.\u201B`   `\u005c  \u005c \u005c
      {`"`        \u005c  ) )
      {       /    \u007c/ /
       \u005c\u005c   ,(     / /
        ) ) /-\u201B\u005c  ,_.\u201B
  jgs  (,(,/ ((,,/
  '

  ,longtailcat =
  '
     /\u005c-/\u005c
    /a a  \u005c                                 _
   =\u005c Y  =/-~~~~~~-,_______________________/ )
     \u201B^--\u201B          ________________________/
       \u005c           /
       \u007c\u007c  \u007c---\u201B\u005c  \u005c
  jgs  (_(__\u007c   ((__\u007c
  '

  ,cat =
  '
            \u007c\u005c___/\u007c
          ==) ^Y^ (==
            \u005c  ^  /
             )=*=(
            /     \u005c
            \u007c     \u007c
           /\u007c \u007c \u007c \u007c\u005c
           \u005c\u007c \u007c \u007c_\u007c/\u005c
      jgs  //_// ___/
               \u005c_)
  '

  ,trilobite =
  "
          _____
       .'` ,-. `'.
      /   ([ ])   \u005c
     /.-\u0022\u0022`(`)`\u0022\u0022-.\u005c
      <'```(.)```'>
      <'```(.)```'>
       <'``(.)``'>
   sk   <``\u005c_/``>
         `'---'`
  "

  ,shark =

  "
              /\u0022\u0022-._
              .       '-,
               :          '',
                ;      *     '.
                 ' *         () '.
                   \u005c               \u005c
                    \u005c      _.---.._ '.
                    :  .' _.--''-''  \u005c ,'
        .._           '/.'             . ;
        ; `-.          ,                \u005c'
         ;   `,         ;              ._\u005c
          ;    \u005c     _,-'                ''--._
          :    \u005c_,-'                          '-._
          \u005c ,-'                       .          '-._
          .'         __.-'';            \u005c...,__       '.
        .'      _,-'        \u005c              \u005c   ''--.,__  '\u005c
        /    _,--' ;         \u005c              ;           \u05c^.}
        ;_,-' )     \u005c  )\u005c      )            ;
             /       \u005c/  \u005c_.,-'             ;
            /                              ;
         ,-'  _,-'''-.    ,-.,            ;      PFA
      ,-' _.-'        \u005c  /    |/'-._...--'
     :--``             )/
  '
  "

  ,buffalo =
"
                   _.-````'-,_
         _,.,_ ,-'`           `'-.,_
       /)     (\                   '``-.
      ((      ) )                      `\u005c
        \u005c)    (_/                        )\u005c
        |       /)           '    ,'    / \u005c
        `\u005c    ^'            '     (    /  ))
          |      _/\u005c ,     /    ,,`\u005c   (  \u0022`
          \u005cY,   |   \u005c  \u005c  | ````| / \u005c_ \u005c
            `)_/      \u005c  \u005c  )    ( >  ( >
                       \u005c( \u005c(     |/   |/
          mic & dwb  /_(/_(    /_(  /_(
    "


  ,grumpycat =
  '
      \uFF8A _ \uFF8A
      \u0CA0 X \u0CA0
  '

  ,smallcat =
  '
         /\\_/\\
        ( o.o )
         > ^ <      [nosig]\n\n' # from https://user.xmission.com/~emailbox/ascii_cats.htm

  ,yoda =
"
                   ____
                _.' :  `._
            .-.'`.  ;   .'`.-.
   __      / : ___\\ ;  /___ ; \\      __
  ,'_ \"\"--.:__;\".-.\";: :\".-.\":__;.--\"\" _`,
  :' `.t\"\"--.. '<@.`;_  ',@>` ..--\"\"j.' `;
       `:-.._J '-.-'L__ `-- ' L_..-;'
          \"-.__ ;  .-\"  \"-.  : __.-\"
             L ' /.------.\\ ' J
             \"-.   \"--\"   .-\"
             __.l\"-:_JL_;-\";.__
         .-j/'.;  ;\"\"\"\"  / .'\\\"-.
         .' /:`. \"-.:     .-\" .';  `.
      .-\"  / ;  \"-. \"-..-\" .-\"  :    \"-.
  .+\"-.  : :      \"-.__.-\"      ;-._   \\
  ; \\  `.; ;                    : : \"+. ;
  :  ;   ; ;                    : ;  : \\:
  ;  :   ; :                    ;:   ;  :
  : \\  ;  :  ;                  : ;  /  ::
  ;  ; :   ; :                  ;   :   ;:
  :  :  ;  :  ;                : :  ;  : ;
  ;\\    :   ; :                ; ;     ; ;
  : `.\"-;   :  ;              :  ;    /  ;
 ;    -:   ; :              ;  : .-\"   :
  :\\     \\  :  ;            : \\.-\"      :
  ;`.    \\  ; :            ;.'_..--  / ;
  :  \"-.  \"-:  ;          :/.\"      .'  :
   \\         \\ :          ;/  __        :
    \\       .-`.\\        /t-\"\"  \":-+.   :
     `.  .-\"    `l    __/ /`. :  ; ; \\  ;
       \\   .-\" .-\"-.-\"  .' .'j \\  /   ;/
        \\ / .-\"   /.     .'.' ;_:'    ;
  :-\"\"-.`./-.'     /    `.___.'
               \\ `t  ._  /  bug
                \"-.t-._:'
  "
  , mushroom =
"
                ________
           __--\u00B4      \u00B0 `--__
       __-\u00B4     \u00B0      \u00B0     `-__
     (\u00B4    \u00B0    \u00B0          \u00B0     `)
     (\u00B0 \u00B0|    |\u00B0         \u00B0 |    | )
      `'''''''''`|'''''|\u00B4''''''''\u00B4
                 |     |
                 |:::::|
               /:|:::::|:\\
              /::|:::::|::\\
                 |     |
                 |^   ^|
                 |  _  | [FK]
                 |_____|
",  # Franz-Sebastian Krah
  endlesshorse =
"
       ,
    _,,)\\.~,,._
     (()`  ``)\\))),,_
      |     \\ ''((\\)))),,_          ____
      |6`   |   ''((\\())) \"-.____.-\"    `-.-,
      |    .'\\    ''))))'                  \\)))
      |   |   `.     ''                     ((((
      \\, _)     \\/                          |))))
       `'        |                          (((((
                 \\                  |       ))))))
                  `|    |           ,\\     /((((((
                   |   / `-.______.<  \\   |  )))))
                   |   |  /         `. \\  \\  ((((
                   |  / \\ |           `.\\  | (((
                   \\  | | |             )| |  ))
                    | | | |             || |  '   [endless.horse]
                    | | | |             || |",

bat =
"
        __.--'\\     \\.__./     /'--.__
    _.-'       '.__.'    '.__.'       '-._
  .'                                      '.
 /                                          \\
|                                            |
|                                            |
 \\         .---.              .---.         /
  '._    .'     '.''.    .''.'     '.    _.'
     '-./            \\  /           \\.-'
                      ''mrf
",
bat2 =
"
_____________________                              _____________________
`-._                 \\           |\\__/|           /                 _.-'
    \\                 \\          |    |          /                 /
     \\                 `-_______/      \\_______-'                 /
      |                                                          |
      |                                                          |
      |                                                          |
      /                                                          \\
     /_____________                                  _____________\\
                   `----._                    _.----'
                          `--.            .--'
                              `-.      .-'
                                 \\    / :F_P:
                                  \\  /
                                   \\/
",
turkey =
"
               .--.
              /} p \\             /}
             `~)-) /           /` }
              ( / /          /`}.' }
               / / .-'\"\"-.  / ' }-'}
              / (.'       \\/ '.'}_.}
             |            `}   .}._}
             |     .-=-';   } ' }_.}
             \\    `.-=-;'  } '.}.-}
              '.   -=-'    ;,}._.}
                `-,_  __.'` '-._}
              jgs   `|||
                   .=='=,
",
monkey =
"
                  .=\"=.
                _/.-.-.\\_     _
               ( ( o o ) )    ))
                |/  \"  \\|    //
                 \\'---'/    //
           jgs   /`\"\"\"`\\\\  ((
                / /_,_\\ \\\\  \\\\
                \\_\\_'__/  \\  ))
                /`  /`~\\   |//
               /   /    \\  /
          ,--`,--'\\/\\    /
          \'-- \"--'  '--'
",

daemon =
"            ,        ,
            /(        )`
            \\ \\___   / |
            /- _  `-/  '
           (/\\/ \\ \\   /\\
           / /   | `    \
           O O   ) /    |
           `-^--'`<     '
          (_.)  _  )   /
           `.___/`    /
             `-----' /
<----.     __ / __   \\
<----|====O)))==) \\) /====
<----'    `--' `.__,' \\
             |        |
              \\       /
        ______( (_  / \\______
      ,'  ,-----'   |        \\
      `--{__________)        \\/ [nosig]
",
#egret by Joan Stark from http://www.chris.com/ascii/joan/www.geocities.com/SoHo/7373/birds.html#egret
egret =
  "
           _,
      -==<' `\
          ) /
         / (_.
        |  ,-,`\\
         \\\\   \\ \\
          `\\,  \\ \\
           ||\\  \\`|,
 jgs      _|| `=`-'
         ~~`~`
",
# duckling by Andreas Brandmaier, @brandmaier
duckling =
  "
        >o  .
         ===    [ab]
",
# duck by Andreas Brandmaier, @brandmaier
duck =
  "
         __
        /o \\
      <=   |         ==
        |__|        /===
        |   \\______/  =
        \\     ====   /
         \\__________/     [ab]
",
# owl by Andreas Brandmaier, @brandmaier
owl =
  "
       /\\___/\\
       {o}{o}|
       \\ v  /|
       |    \\ \\
        \\___/_/       [ab]
          | |
",
# squirrel by Marion Louveaux, @marionlouveaux
squirrel =
  "
                      . .
                      |\\|\\_
                      /  ^ \\
                     /  _-_/\u00B0
   \\\\\\\\\\\\\\\\\\       /   / \\
  ////////////   /  \\ / ||
 \\\\\\\\\\\\\\\\\\\\\\\\\\\\ /   /\\\\ \\\\
////////////////   /  \\\\ \\\\
 \\\\\\\\\\\\\\\\\\\\\\\\\\/   /  / `` ``
     /////////   \\  /  \\
 ML     \\\\\\\\\\\\___/_/___/
",
# squirrel2 by Marion Louveaux, @marionlouveaux
 squirrel2 =
  "
                      . .
                      |\\|\\_
                      /  @ \\
                     /  _-_/\u00B0
   \\\\\\\\\\\\\\\\\\       /   / \\
  ////////////   /  \\ / ||
 \\\\\\\\\\\\\\\\\\\\\\\\\\\\ /   /\\\\ \\\\
////////////////   /  \\\\ \\\\
 \\\\\\\\\\\\\\\\\\\\\\\\\\/   /  / `` ``
     /////////   \\  /  \\
 ML     \\\\\\\\\\\\___/_/___/
",
#Art by Max Strandberg, https://www.asciiart.eu/animals/fish
goldfish=
  "
            /\`-._
           /_,.._\`:-
      ,.-'  ,   \`-:..-')
      : o ):';      _  {
       \`-._ \`'__,.-'\\\`-.)
           \`\\\\  \\,.-'\`   Max
",
#Art by Shanaka Dias

alligator=
  "
           .-._   _ _ _ _ _ _ _ _
.-''-.__.-'00  '-' ' ' ' ' ' ' ' '-.
'.___ '    .   .--_'-' '-' '-' _'-' '._
V: V 'vv-'   '_   '.       .'  _..' '.'.
  '=.____.=_.--'   :_.__.__:_   '.   : :
           (((____.-'        '-.  /   : :
snd                          (((-'\\ .' /
                           _____..'  .'
                          '-._____.-'
",
# https://www.asciiart.eu/animals/reptiles/dinosaurs by Michael John Wagoner
stegosaurus=
    "
                         .       .
                        / `.   .' \\
                .---.  <    > <    >  .---.
                |    \\  \\ - ~ ~ - /  /    |
                 ~-..-~             ~-..-~
             \\~~~\\.'                    `./~~~/
   .-~~^-.    \\__/                        \\__/
 .'  O    \\     /               /       \\  \\
(_____,    `._.'               |         }  \\/~~~/
 `----.          /       }     |        /    \\__/
       `-.      |       /      |       /      `. ,~~|
           ~-.__|      /_ - ~ ^|      /- _      `..-'   f: f:
                |     /        |     /     ~-.     `-. _||_||_
                |_____|        |_____|         ~ - . _ _ _ _ _>
",
# https://asciiart.website/index.php?art=animals/other%20(water)
whale=
  "
     .-'
'--./ /     _.---.
'-,  (__..-`       \\
   \\          .     |
    `,.__.   ,__.--/
     '._/_.'___.-`
",
#https://www.asciiart.eu/animals/wolves

wolf=
  "
                    .
                   / V\\
                  / \`  /
                 <<   |
                 /    |
               /      |
             /        |
           /    \\  \\ /
          (      ) | |
  ________|   _/_  | |
<__________\\______)\\__)"

)
