% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_distance_mat.R
\name{get_distance_matrix}
\alias{get_distance_matrix}
\title{Compute all shortest distance between origin and destination nodes.}
\usage{
get_distance_matrix(Graph, from, to, allcores = FALSE)
}
\arguments{
\item{Graph}{An object generated by cppRouting::makegraph() function.}

\item{from}{A vector of one or more vertices from which distances are calculated (origin).}

\item{to}{A vector of one or more vertices (destination).}

\item{allcores}{Logical. If TRUE, all cores are used.}
}
\value{
Matrix of shortest distances.
}
\description{
Compute all shortest distance between origin and destination nodes.
}
\note{
get_distance_matrix() recursively perform Dijkstra algorithm for each 'from' nodes.
}
\examples{
#Data describing edges of the graph
edges<-data.frame(from_vertex=c(0,0,1,1,2,2,3,4,4), 
                  to_vertex=c(1,3,2,4,4,5,1,3,5), 
                  cost=c(9,2,11,3,5,12,4,1,6))
#Get all nodes
nodes<-unique(c(edges$from_vertex,edges$to_vertex))
 
#Construct directed and undirected graph 
directed_graph<-makegraph(edges,directed=TRUE)
non_directed<-makegraph(edges,directed=FALSE)

#Get matrix of distance between all nodes in the two graphs
dir_dist<-get_distance_matrix(Graph=directed_graph, from=nodes, to=nodes, allcores=FALSE)
non_dir_dist<-get_distance_matrix(Graph=non_directed, from=nodes, to=nodes, allcores=FALSE)
print(dir_dist)
print(non_dir_dist)
}
