% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack.R
\name{cpp_stack}
\alias{cpp_stack}
\title{Create stack}
\usage{
cpp_stack(x)
}
\arguments{
\item{x}{An integer, numeric, character, or logical vector.}
}
\value{
Returns a CppStack object referencing a stack in C++.
}
\description{
Create a stack. Stacks are last-in, first-out containers.
}
\details{
The last element added to a stack is the first one to remove.

C++ stack methods implemented in this package are \link{emplace}, \link{empty}, \link{pop}, \link{push}, \link{size}, and \link{top}. The package also 
adds the \link{==} operator and various helper functions (\link{print}, \link{to_r}, \link{type}).

All object-creating methods in this package begin with \code{cpp_} to avoid clashes with functions from other packages, such as \code{utils::stack} and 
\code{base::vector}.
}
\examples{
s <- cpp_stack(4:6)
s
# Top element: 6

emplace(s, 3L)
s
# Top element: 3

push(s, 9L)
s
# Top element: 9

pop(s)
s
# Top element: 3

}
\seealso{
\link{cpp_queue}, \link{cpp_priority_queue}.
}
