% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cn.R
\name{cn}
\alias{cn}
\alias{cn.cpr_bt}
\alias{cn.formula}
\alias{print.cpr_cn}
\alias{summary.cpr_cn}
\title{Control Nets}
\usage{
cn(x, ...)

\method{cn}{cpr_bt}(x, theta, ...)

\method{cn}{formula}(formula, data, method = stats::lm, ..., keep_fit = FALSE, check_rank = TRUE)

\method{print}{cpr_cn}(x, ...)

\method{summary}{cpr_cn}(object, ...)
}
\arguments{
\item{x}{a \code{cpr_bs} object}

\item{...}{arguments passed to the regression method}

\item{theta}{a vector of (regression) coefficients, the ordinates of the
control net.}

\item{formula}{a formula that is appropriate for regression method being
used.}

\item{data}{a required \code{data.frame}}

\item{method}{the regression method such as \code{\link[stats]{lm}},
\code{\link[stats]{glm}}, \code{\link[lme4]{lmer}}, etc.}

\item{keep_fit}{(logical, defaults to \code{FALSE}).  If \code{TRUE} the
regression model fit is retained and returned in the the \code{fit} element.
If \code{FALSE} the regression model is not saved and the \code{fit} element will be \code{NA}.}

\item{check_rank}{(logical, defaults to \code{TRUE}) if TRUE check that the
design matrix is full rank.}

\item{object}{a \code{cpr_cn} object}
}
\value{
a \code{cpr_cn} object.  This is a list with the following elements.
Some of the elements are omitted when the using the \code{cn.cpr_bt} method.
\describe{
 \item{cn}{the control net, \code{data.frame} with each row defining a vertex
 of the control net}
 \item{bspline_list}{A list of the marginal B-splines}
 \item{call}{the call}
 \item{keep_fit}{logical, indicates if the regression models was retained}
 \item{fit}{if \code{isTRUE(keep_fit)} then the regression model is here,
 else \code{NA}.}
 \item{coefficients}{regression coefficients, only the fixed effects if a
 mixed effects model was used.}
 \item{vcov}{The variance-covariance matrix for the \code{coefficients}}
 \item{loglik}{The log-likelihood for the regression model}
 \item{rmse}{The root mean squared error for the regression models}
 }
}
\description{
Generate the control net for a uni-variable B-spline
}
\details{
\code{cn} generates the control net for the given B-spline function.  There
are several methods for building a control net.
}
