% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCuminc.R
\name{plotCuminc}
\alias{plotCuminc}
\title{Cumulative incidences curves}
\usage{
plotCuminc(ci, cens = NULL, target = NULL, ggtheme = theme_minimal(),
  titleCuminc = "Cumulative incidence functions", xtitle = "Time",
  ytitleCuminc = "Cumulative incidences", legendtitle = "Group")
}
\arguments{
\item{ci}{a result of function fitCuminc.}

\item{cens}{value of 'risk' indicating censored observation (default 0).}

\item{target}{point in time, in which the confidence bounds should be plotted (default NULL, no confidence bounds plotted).}

\item{ggtheme}{ggtheme to be used (default: theme_minimal()).}

\item{titleCuminc}{a title of a plot (default: "Cumulative incidence functions").}

\item{xtitle}{a title of x axis (default: "Time").}

\item{ytitleCuminc}{a title of y axis (default: "Cumulative incidences")}

\item{legendtitle}{a title of a legend (default: "Group").}
}
\value{
a ggplot containing n graphs, where n is number of risks. Each graph represents cumulative incidence curves for given risk.  One curve corresponds to one group.
}
\description{
Plots cumulative incidences curves for each risk and group.
}
\examples{
fitC <- fitCuminc(time = LUAD$time, risk = LUAD$event, group = LUAD$gender, cens = "alive")
plotCuminc(ci = fitC, cens = "alive", target = 1200)
}
\seealso{
\code{\link[ggplot2]{ggplot}} \code{\link[ggplot2]{ggtheme}}
}
