% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_visualization.R
\name{plot_density}
\alias{plot_density}
\title{Plot Density}
\usage{
plot_density(
  dat,
  x,
  y = NULL,
  m = 3,
  g = 5,
  y_breaks = NULL,
  hist = 2,
  binwidth = NULL,
  pl_theme = plot_theme(legend.position = "top", title_size = 9, legend_size = 7,
    axis_title_size = 8),
  colors_y = c(love_color(type = "deep"), love_color(type = "light"), love_color(type =
    "shallow"))
)
}
\arguments{
\item{dat}{A data.frame with independent variables and target variable.}

\item{x}{The name of an independent variable.}

\item{y}{The name of target variable.}

\item{m}{The outlier cutoff.}

\item{g}{Number of initial breakpoints for equal frequency binning.}

\item{y_breaks}{Breaks points of y.}

\item{hist}{If plot the histogram,-1,1,2, default is 2.}

\item{binwidth}{Windth of bins for histogram.}

\item{pl_theme}{Theme of plot}

\item{colors_y}{colors of y.}
}
\description{
You can use the \code{plot_density} to produce plots that characterize the density.
}
\examples{
plot_density(dat = lendingclub, x = "annual_inc",y = "emp_length", m =0, hist = -1)
plot_density(dat = lendingclub, x = "annual_inc", m = 2,
colors_y = love_color(type = "line")[c(1,3)])
}
