% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crew_queue.R
\name{crew_class_queue}
\alias{crew_class_queue}
\title{\code{R6} queue class}
\description{
\code{R6} class for a queue of resolved task names.
}
\details{
See \code{\link[=crew_queue]{crew_queue()}}.
}
\examples{
crew_queue()
}
\seealso{
Other queue: 
\code{\link{crew_queue}()}
}
\concept{queue}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{names}}{Names of resolved tasks.}

\item{\code{head}}{Non-negative integer pointing to the location of the
next name to pop.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-crew_class_queue-validate}{\code{crew_class_queue$validate()}}
\item \href{#method-crew_class_queue-reset}{\code{crew_class_queue$reset()}}
\item \href{#method-crew_class_queue-set}{\code{crew_class_queue$set()}}
\item \href{#method-crew_class_queue-pop}{\code{crew_class_queue$pop()}}
\item \href{#method-crew_class_queue-collect}{\code{crew_class_queue$collect()}}
\item \href{#method-crew_class_queue-empty}{\code{crew_class_queue$empty()}}
\item \href{#method-crew_class_queue-nonempty}{\code{crew_class_queue$nonempty()}}
\item \href{#method-crew_class_queue-popped}{\code{crew_class_queue$popped()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_queue-validate"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_queue-validate}{}}}
\subsection{Method \code{validate()}}{
Validate the queue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_queue$validate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly). Called for its side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_queue-reset"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_queue-reset}{}}}
\subsection{Method \code{reset()}}{
Reset the queue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_queue$reset()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{NULL} (invisibly). Called for its side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_queue-set"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_queue-set}{}}}
\subsection{Method \code{set()}}{
Set the names in the queue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_queue$set(names = character(0L))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{names}}{Character vector of names to set.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{NULL} (invisibly). Called for its side effects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_queue-pop"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_queue-pop}{}}}
\subsection{Method \code{pop()}}{
Pop a name off the queue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_queue$pop()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character string, a name popped off the queue.
\code{NULL} if there are no more names available to pop.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_queue-collect"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_queue-collect}{}}}
\subsection{Method \code{collect()}}{
Remove and return all available names off the queue.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_queue$collect()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Character vector, names collected from the queue.
\code{NULL} if there are no more names available to collect.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_queue-empty"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_queue-empty}{}}}
\subsection{Method \code{empty()}}{
Report if the queue is empty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_queue$empty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if the queue is empty, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_queue-nonempty"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_queue-nonempty}{}}}
\subsection{Method \code{nonempty()}}{
Report if the queue is nonempty.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_queue$nonempty()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{TRUE} if the queue is nonempty, \code{FALSE} otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-crew_class_queue-popped"></a>}}
\if{latex}{\out{\hypertarget{method-crew_class_queue-popped}{}}}
\subsection{Method \code{popped()}}{
List the names already popped.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{crew_class_queue$popped()}\if{html}{\out{</div>}}
}

\subsection{Details}{
\code{set()}, \code{reset()}, and \code{collect()} remove these names.
}

\subsection{Returns}{
Character vector of names already popped.
}
}
}
