% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sch_activity.R
\name{sch_change_activities_duration}
\alias{sch_change_activities_duration}
\title{Change Activities Duration}
\usage{
sch_change_activities_duration(sch, new_durations)
}
\arguments{
\item{sch}{A schedule object.}

\item{new_durations}{A vector with new activities' duration.}
}
\value{
A schedule object with new durations.
}
\description{
Change activities duration and calculates critical path.
This way is faster than creating a new schedule with new durations.
The order of duration is the insertion order of activities.
}
\examples{
sch <- sch_new() \%>\%
  sch_title("Project 2: Patient Transport System") \%>\%
  sch_reference(
    "VANHOUCKE, Mario. Integrated project management and control:
  first comes the theory, then the practice. Gent: Springer, 2014, p. 9") \%>\%
  sch_add_activities(
    id        = 1:17,
    name      = paste("a", as.character(1:17), sep=""),
    duration  = c(1L,1L,3L,2L, 2L,2L,2L,1L, 4L,5L,3L,3L, 4L,5L,1L,5L,2L)
  ) \%>\%
  sch_add_relations(
    from = c(1L, 2L, 3L, 3L, 4L, 5L, 6L, 7L, 8L,  8L,  8L,
             8L,  8L,  9L, 10L, 11L, 12L, 13L, 13L, 14L, 14L, 15L, 15L),
    to   = c(2L, 3L, 4L, 6L, 5L, 8L, 7L, 8L, 9L, 10L, 11L,
             12L, 13L, 14L, 14L, 14L, 14L, 14L, 15L, 16L, 17L, 16L, 17L)
  ) \%>\%
  sch_plan()

# Project duration
sch_duration(sch) # 25
# Activities duration
atb <- sch_activities(sch)
atb$duration

# Now, change activities duration
new_durations <- c(1L,2L,5L, 4L,3L, 2L,1L, 5L, 3L,5L,5L,3L,4L, 2L,1L, 2L,4L)
sch \%<>\%
  sch_change_activities_duration(new_durations)

#Project duration
sch_duration(sch) # 31
# Activities duration
atb <- sch_activities(sch)
atb$duration

}
\seealso{
\code{\link[=sch_activities]{sch_activities()}}, \code{\link[=sch_has_any_activity]{sch_has_any_activity()}}, \code{\link[=sch_duration]{sch_duration()}},
\code{\link[=sch_nr_activities]{sch_nr_activities()}}, \code{\link[=sch_add_activity]{sch_add_activity()}}, \code{\link[=sch_add_activities]{sch_add_activities()}},
\code{\link[=sch_get_activity]{sch_get_activity()}}.
}
