% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/Data-methods.R
\docType{methods}
\name{plot,Data,missing-method}
\alias{plot,Data,missing-method}
\title{Plot method for the "Data" class}
\usage{
\S4method{plot}{Data,missing}(x, y, blind = FALSE, ...)
}
\arguments{
\item{x}{the \code{\linkS4class{Data}} object we want to plot}

\item{y}{missing}

\item{blind}{Logical (default FALSE) if to blind the data. If TRUE, then placebo
subjects are reported by the active dose level of the corresponding cohort and
DLEs are always assigned to the firsts subjects.}

\item{\dots}{not used}
}
\value{
the \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot method for the "Data" class
}
\examples{

# Create some data of class 'Data'
myData <- Data(x=c(0.1,0.5,1.5,3,6,10,10,10),
               y=c(0,0,0,0,0,0,1,0),
               doseGrid=c(0.1,0.5,1.5,3,6,
                          seq(from=10,to=80,by=2)))

# Plot the data
plot(myData)

}
\keyword{methods}

