% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulations-class.R
\docType{class}
\name{PseudoSimulationsSummary-class}
\alias{.PseudoSimulationsSummary}
\alias{PseudoSimulationsSummary-class}
\title{Class for the summary of pseudo-models simulations output}
\description{
Note that objects should not be created by users, therefore no
initialization function is provided for this class.
}
\section{Slots}{

\describe{
\item{\code{targetEndOfTrial}}{the target probability of DLE wanted at the end of a trial}

\item{\code{targetDoseEndOfTrial}}{the dose level corresponds to the target probability
of DLE wanted at the end of a trial, TDEOT}

\item{\code{targetDoseEndOfTrialAtDoseGrid}}{the dose level at dose grid corresponds to the target probability
of DLE wanted at the end of a trial}

\item{\code{targetDuringTrial}}{the target probability of DLE wanted during a trial}

\item{\code{targetDoseDuringTrial}}{the dose level corresponds to the target probability of DLE
wanted during the trial. TDDT}

\item{\code{targetDoseDuringTrialAtDoseGrid}}{the dose level at dose grid corresponds to the target probability
of DLE wanted during a trial}

\item{\code{TDEOTSummary}}{the six-number table summary, include the lowest, the 25th precentile (lower quatile), 
the 50th percentile (median), the mean, the 27th percentile and the highest values of the 
final dose levels obtained corresponds to the target probability of DLE
want at the end of a trial across all simulations}

\item{\code{TDDTSummary}}{the six-number table summary, include the lowest, the 25th precentile (lower quatile), 
the 50th percentile (median), the mean, the 27th percentile and the highest values of the 
final dose levels obtained corresponds to the target probability of DLE
want during a trial across all simulations}

\item{\code{FinalDoseRecSummary}}{the six-number table summary, include the lowest, the 25th precentile (lower quatile), 
the 50th percentile (median), the mean, the 27th percentile and the highest values of the 
final optimal doses, which is either the TDEOT when only DLE response are incorporated into 
the escalation procedure or the minimum of the TDEOT and Gstar when DLE and efficacy responses are
incorporated, across all simulations}

\item{\code{ratioTDEOTSummary}}{the six-number summary table of the final ratios of the upper to the lower 95\%
credibility intervals of the final TDEOTs across all simulations}

\item{\code{FinalRatioSummary}}{the six-number summary table of the final ratios of the upper to the lower 95\%
credibility intervals of the final optimal doses across all simulations
#@slot doseRec the dose level that will be recommend for subsequent study}

\item{\code{nsim}}{number of simulations}

\item{\code{propDLE}}{proportions of DLE in the trials}

\item{\code{meanToxRisk}}{mean toxicity risks for the patients}

\item{\code{doseSelected}}{doses selected as MTD (targetDoseEndOfTrial)}

\item{\code{toxAtDosesSelected}}{true toxicity at doses selected}

\item{\code{propAtTargetEndOfTrial}}{Proportion of trials selecting at the doseGrid closest below the MTD, the 
targetDoseEndOfTrial}

\item{\code{propAtTargetDuringTrial}}{Proportion of trials selecting at the doseGrid closest below the 
targetDoseDuringTrial}

\item{\code{doseMostSelected}}{dose most often selected as MTD}

\item{\code{obsToxRateAtDoseMostSelected}}{observed toxicity rate at dose most often
selected}

\item{\code{nObs}}{number of patients overall}

\item{\code{nAboveTargetEndOfTrial}}{number of patients treated above targetDoseEndOfTrial}

\item{\code{nAboveTargetDuringTrial}}{number of patients treated above targetDoseDuringTrial}

\item{\code{doseGrid}}{the dose grid that has been used}

\item{\code{fitAtDoseMostSelected}}{fitted toxicity rate at dose most often selected}

\item{\code{meanFit}}{list with the average, lower (2.5%) and upper (97.5%)
quantiles of the mean fitted toxicity at each dose level}
}}
\keyword{classes}

