% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data-validity.R
\name{v_data_objects}
\alias{v_data_objects}
\alias{v_general_data}
\alias{h_doses_unique_per_cohort}
\alias{v_data}
\alias{v_data_dual}
\alias{v_data_parts}
\alias{v_data_mixture}
\alias{v_data_da}
\alias{v_data_ordinal}
\alias{v_data_grouped}
\title{Internal Helper Functions for Validation of \code{\link{GeneralData}} Objects}
\usage{
v_general_data(object)

h_doses_unique_per_cohort(dose, cohort)

v_data(object)

v_data_dual(object)

v_data_parts(object)

v_data_mixture(object)

v_data_da(object)

v_data_ordinal(object)

v_data_grouped(object)
}
\arguments{
\item{object}{(\code{GeneralData})\cr object to validate.}

\item{dose}{(\code{numeric})\cr dose values.}

\item{cohort}{(\code{integer})\cr cohort indices parallel to \code{doses}.}
}
\value{
A \code{character} vector with the validation failure messages,
or \code{TRUE} in case validation passes.

\code{TRUE} if \code{dose} is unique per \code{cohort}, otherwise \code{FALSE}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

These functions are only used internally to validate the format of an input
\code{\link{GeneralData}} or inherited classes and therefore not exported.
}
\section{Functions}{
\itemize{
\item \code{v_general_data()}: validates that the \code{\link{GeneralData}}
object contains unique \code{ID}, non-negative \code{cohort} indices and
\code{ID} and \code{cohort} vectors are of the same length \code{nObs}.

\item \code{h_doses_unique_per_cohort()}: helper function which verifies whether
the \code{dose} values are unique in each and every different \code{cohort}.

\item \code{v_data()}: validates that the \code{\link{Data}} object contains
valid elements with respect to their types, dependency and length.

\item \code{v_data_dual()}: validates that the \code{\link{DataDual}} object
contains valid biomarker vector with respect to its type and the length.

\item \code{v_data_parts()}: validates that the \code{\link{DataParts}} object
contains valid elements with respect to their types, dependency and length.

\item \code{v_data_mixture()}: validates that the \code{\link{DataMixture}} object
contains valid elements with respect to their types, dependency and length.

\item \code{v_data_da()}: validates that the \code{\link{DataDA}} object
contains valid elements with respect to their types, dependency and length.

\item \code{v_data_ordinal()}: validates that the \code{\link{DataOrdinal}} object
contains valid elements with respect to their types, dependency and length.

\item \code{v_data_grouped()}: validates that the \code{\link{DataGrouped}} object
contains valid group information.

}}
