% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cron_add.R
\name{cron_add}
\alias{cron_add}
\alias{cronjob}
\title{Make a simple cron job}
\usage{
cron_add(command, frequency = "daily", at, days_of_month, days_of_week,
  months, id, tags = "", description = "", dry_run = FALSE, user = "")

cronjob(command, frequency = "daily", at, days_of_month, days_of_week, months,
  id, tags = "", description = "", dry_run = FALSE, user = "")
}
\arguments{
\item{command}{A command to execute.}

\item{frequency}{A character string equal to one of 
\code{"minutely"}, \code{"hourly"}, \code{"daily"},
\code{"monthly"}, or \code{"yearly"}.}

\item{at}{The actual time of day at which to execute the command.
When unspecified, we default to \code{"3AM"}, when the command is to
be run less frequently than \code{"hourly"}.}

\item{days_of_month}{Optional; the day(s) of the month on which we execute the
command.}

\item{days_of_week}{Optional; the day(s) of the week on which we execute the
command.}

\item{months}{Optional; the month(s) of the year on which we execute
the command.}

\item{id}{An id, or name, to give to the cronjob task, for easier
revision in the future.}

\item{tags}{A set of tags, used for easy listing and retrieval
of cron jobs.}

\item{description}{A short description of the job, and its purpose.}

\item{dry_run}{Boolean; if \code{TRUE} we do not submit the cron job; 
instead we return the parsed text that would be submitted as a cron job.}

\item{user}{The user whose cron jobs we wish to examine.}
}
\description{
Generate a cron job, and pass it to crontab.

The goal is to be able to translate simple English statements of intent
to the actual \code{cron} statement that could execute that intent. For example,

\emph{"I want to run a job daily at 7AM."}

is simply

\code{cron_add(<command>, "daily", at="7AM")}

Another example, \emph{"I want to run a job on the 15th of every month."}

is

\code{cron_add(<command>, "monthly", days_of_month="15th")}
}
\examples{
\dontrun{
f <- system.file(package = "cronR", "extdata", "helloworld.R")
cmd <- cron_rscript(f)
cmd

cron_add(command = cmd, frequency = 'minutely', 
  id = 'test1', description = 'My process 1', tags = c('lab', 'xyz'))
cron_add(command = cmd, frequency = 'daily', at='7AM', id = 'test2')
cron_njobs()

cron_ls()
cron_clear(ask=FALSE)
cron_ls()

cmd <- cron_rscript(f, rscript_args = c("productx", "arg2", "123"))
cmd
cron_add(cmd, frequency = 'minutely', id = 'job1', description = 'Customers')
cron_add(cmd, frequency = 'hourly', id = 'job2', description = 'Weather')
cron_add(cmd, frequency = 'hourly', id = 'job3', days_of_week = c(1, 2))
cron_add(cmd, frequency = 'hourly', id = 'job4', at = '00:20', days_of_week = c(1, 2))
cron_add(cmd, frequency = 'daily', id = 'job5', at = '14:20')
cron_add(cmd, frequency = 'daily', id = 'job6', at = '14:20', days_of_week = c(0, 3, 5))
cron_add(cmd, frequency = 'daily', id = 'job7', at = '23:59', days_of_month = c(1, 30))
cron_add(cmd, frequency = 'monthly', id = 'job8', at = '10:30', 
  days_of_month = 'first', days_of_week = '*')
cron_ls()
cron_clear(ask=FALSE)
}
}

