% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmean_monthly_stack.R
\name{tmean_monthly_stack}
\alias{tmean_monthly_stack}
\title{Monthly mean air temperature estimation to generate the climate crop zoning
\if{html}{\figure{logo_cropZoning.png}{options: height= 300 width=auto style = float:right alt= Our logo}}}
\usage{
tmean_monthly_stack(tmean_stack, start_date, end_date)
}
\arguments{
\item{tmean_stack}{Stack of mean air temperature based on minimum and maximum air temperature Rasterstack}

\item{start_date}{Date that start the investigation, should be in the following format (1958-01-01 /Year-Month-Day)}

\item{end_date}{Date that end the investigation, should be in the following format (2017-12-31 /Year-Month-Day)}
}
\value{
Returns a Rasterstack object with a monthly mean air temperature from a period of time.
}
\description{
This function will calculate the mean monthly air temperature based on the period of time selected (start_date and end_date).
}
\examples{
\dontrun{

start_date <- c('2000-01-01')
end_date <- c('2017-12-01')

tmean_monthly <- tmean_monthly_stack(tmean_stack = img_tmean,
                                    start_date = start_date,
                                    end_date = end_date)
}
}
