% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop.R
\name{circle_crop}
\alias{circle_crop}
\title{Circle crop}
\usage{
circle_crop(
  images,
  to = NULL,
  border_size = NULL,
  border_colour = "black",
  just = "center"
)
}
\arguments{
\item{images}{Vector of image paths, either local or urls. If urls the images
will be downloaded first.}

\item{to}{Path to new location}

\item{border_size}{Border size in pixels.}

\item{border_colour}{Border colour.}

\item{just}{Where to justify the image prior to cropping. Accepted values: `left`, `right`, `top`, `bottom`}
}
\value{
Path to cropped images
}
\description{
Reads in an image and circle crops it with a transparent
background. If a new path is given it will save the cropped images to
the new location. If no path is given it will save to a temporary location
which will be cleared when the session is closed
}
\examples{
library(magick)

x <- c(1, 3, 9, 8)
path <- "https://openpsychometrics.org/tests/characters/test-resources/pics/BB/"
img_paths <- paste0(path, x, ".jpg")

img_paths_cropped <- circle_crop(img_paths, border_size = 6)

imgs <- image_read(img_paths_cropped)
image_montage(imgs)

# justification example
img_path <- file.path(system.file(package = "cropcircles"), "images", "walter-jesse.png")
image_read(img_path)

# center (default)
image_read(circle_crop(img_path, border_size = 10))

# left
image_read(circle_crop(img_path, border_size = 10, just = "left"))

# right
image_read(circle_crop(img_path, border_size = 10, just = "right"))
}
