% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{gfilter.np}
\alias{gfilter.np}
\title{Method to filter graph based on network potential values.}
\usage{
gfilter.np(g, val, use_ppi = TRUE, n = 500, desc, ...)
}
\arguments{
\item{g}{igraph object}

\item{val}{named numeric vector - some measure of node state (i.e. gene expression in the case of a PPI)}

\item{use_ppi}{bool - should we use a ppi from online repository?}

\item{n}{int - number of nodes to include in the returned subgraph}

\item{desc}{bool - do we want the top or bottom examples of the provided metric}

\item{...}{additional params passed to \code{\link[=load_ppi]{load_ppi()}} or \code{\link[=compute_crosstalk]{compute_crosstalk()}}}
}
\value{
igraph
}
\description{
convenience function - it just calls gfilter.value after computing np
}
\details{
For more information on network potential, see \href{https://journals.plos.org/ploscompbiol/article/comments?id=10.1371/journal.pcbi.1008755}{related paper}
}
